/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocUtils;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.variables.ConfigVar;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.xcontent.ToXContent;

public class BulkConfigApi {
    private static final Logger log = LogManager.getLogger(BulkConfigApi.class);
    public static final RestApi REST_API = new RestApi().responseHeaders(SearchGuardVersion.header()).handlesGet("/_searchguard/config").with((Action)GetAction.INSTANCE).handlesPut("/_searchguard/config").with((Action)UpdateAction.INSTANCE).name("/_searchguard/config");

    public static class GetAction
    extends Action<StandardRequests.EmptyRequest, Response> {
        public static final GetAction INSTANCE = new GetAction();
        public static final String NAME = "cluster:admin:searchguard:config/bulk/get";

        protected GetAction() {
            super(NAME, StandardRequests.EmptyRequest::new, Response::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.EmptyRequest, Response> {
            private final ConfigurationRepository configurationRepository;
            private final ConfigVarService configVarService;
            private final ConfigurationLoader configLoader;
            private final AuditLog auditLog;
            private static final ToXContent.Params OMIT_DEFAULTS_PARAMS = new ToXContent.MapParams((Map)ImmutableMap.of((Object)"omit_defaults", (Object)"true"));

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository, ConfigVarService configVarService, BaseDependencies baseDependencies) {
                super((Action)INSTANCE, handlerDependencies);
                this.configurationRepository = configurationRepository;
                this.configVarService = configVarService;
                this.auditLog = baseDependencies.getAuditLog();
                this.configLoader = new ConfigurationLoader(baseDependencies.getLocalClient(), configurationRepository);
            }

            protected CompletableFuture<Response> doExecute(StandardRequests.EmptyRequest request) {
                return this.supplyAsync(this::lambda$doExecute$0);
            }

            private void logComplianceEvent(ConfigMap configMap) {
                LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
                for (SgDynamicConfiguration<?> config : configMap.getAll()) {
                    fields.put(config.getCType().toLCString(), Strings.toString(config));
                }
                this.auditLog.logDocumentRead(this.configurationRepository.getEffectiveSearchGuardIndex(), "*", null, fields);
            }

            /*
             * Unable to fully structure code
             */
            private /* synthetic */ Response lambda$doExecute$0() {
                try {
                    configMap = this.configLoader.loadSync(CType.all(), "GET Bulk API Request", this.configurationRepository.getParserContext());
                    this.logComplianceEvent(configMap);
                    result = new LinkedHashMap<String, Object>();
                    for (SgDynamicConfiguration<?> config : configMap.getAll()) {
                        resultEntry = new LinkedHashMap<String, Object>();
                        if (config.getUninterpolatedJson() != null) {
                            if (config.getCType().getArity() == CType.Arity.SINGLE) {
                                try {
                                    parsedConfig = DocNode.parse((Format)Format.JSON).from(config.getUninterpolatedJson());
                                    if (!parsedConfig.hasNonNull("default")) ** GOTO lbl22
                                    resultEntry.put("content", parsedConfig.get("default"));
                                }
                                catch (DocumentParseException e) {
                                    throw new ConfigUnavailableException(e);
                                }
                            } else {
                                resultEntry.put("content", UnparsedDocument.fromJson((String)config.getUninterpolatedJson()));
                            }
                        } else {
                            resultEntry.put("content", ObjectTreeXContent.toObjectTree(config, (ToXContent.Params)Handler.OMIT_DEFAULTS_PARAMS));
                        }
lbl22:
                        // 4 sources

                        if (config.documentExists()) {
                            resultEntry.put("exists", true);
                            resultEntry.put("_version", config.getDocVersion());
                            resultEntry.put("_seq_no", config.getSeqNo());
                            resultEntry.put("_primary_term", config.getPrimaryTerm());
                            resultEntry.put("_etag", config.getETag());
                        } else {
                            resultEntry.put("exists", false);
                        }
                        result.put(config.getCType().toLCString(), resultEntry);
                    }
                    result.put("config_vars", ImmutableMap.of((Object)"content", this.configVarService.getAllFromIndex()));
                    return new Response(result);
                }
                catch (ConfigUnavailableException e) {
                    throw new CompletionException(e);
                }
            }
        }

        public static class Response
        extends Action.Response {
            private Map<String, Object> config;

            public Response() {
            }

            public Response(Map<String, Object> config) {
                this.config = config;
            }

            public Response(Action.UnparsedMessage message) throws ConfigValidationException {
                this.config = message.requiredDocNode().toMap();
            }

            public Object toBasicObject() {
                return this.config;
            }
        }
    }

    public static class UpdateAction
    extends Action<Request, StandardResponse> {
        public static final UpdateAction INSTANCE = new UpdateAction();
        public static final String NAME = "cluster:admin:searchguard:config/bulk/update";

        protected UpdateAction() {
            super(NAME, Request::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configurationRepository;
            private final ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configurationRepository = configurationRepository;
                this.configVarService = configVarService;
            }

            protected final CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    try {
                        Map<CType<?>, ConfigurationRepository.ConfigWithMetadata> configMap = this.parseConfigJson(request.getConfig());
                        ConfigurationRepository.ConfigWithMetadata configVars = configMap.get(CType.CONFIG_VARS);
                        if (configVars != null && configVars.getContent() != null) {
                            configMap.remove(CType.CONFIG_VARS);
                            try {
                                StandardResponse response = this.configVarService.updateAll(configVars.getContent()).get();
                                if (response.getStatus() >= 300) {
                                    return response;
                                }
                            }
                            catch (InterruptedException e) {
                                log.error("Error while updating configuration", (Throwable)e);
                                return new StandardResponse(500).error(e.getMessage());
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() instanceof ConfigValidationException) {
                                    return new StandardResponse(400).error((ConfigValidationException)e.getCause());
                                }
                                log.error("Error while updating configuration", (Throwable)e);
                                return new StandardResponse(500).error(e.getMessage());
                            }
                        }
                        if (!configMap.isEmpty()) {
                            Map<CType<?>, ConfigurationRepository.ConfigUpdateResult> result = this.configurationRepository.update(configMap);
                            return new StandardResponse(200).message("Configuration has been updated").data(result);
                        }
                        return new StandardResponse(200).message("No configuration was provided");
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(e);
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage()).data(e.getUpdateResult());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while updating configuration", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap()).data(e.getUpdateResult());
                    }
                });
            }

            private Map<CType<?>, ConfigurationRepository.ConfigWithMetadata> parseConfigJson(UnparsedDocument<?> unparsedDoc) throws ConfigValidationException {
                Map parsedJson = unparsedDoc.parseAsMap();
                ValidationErrors validationErrors = new ValidationErrors();
                HashMap configTypeToConfigMap = new HashMap();
                for (String configTypeName : parsedJson.keySet()) {
                    CType<?> ctype;
                    try {
                        ctype = CType.valueOf(configTypeName.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        validationErrors.add(new ValidationError(configTypeName, "Invalid config type: " + configTypeName));
                        continue;
                    }
                    Object value = parsedJson.get(configTypeName);
                    if (!(value instanceof Map)) {
                        validationErrors.add((ValidationError)new InvalidAttributeValue(configTypeName, value, (Object)"A config JSON document"));
                        continue;
                    }
                    Object content = ((Map)value).get("content");
                    if (content == null) {
                        validationErrors.add((ValidationError)new MissingAttribute(configTypeName + ".content"));
                        continue;
                    }
                    if (!(content instanceof Map)) {
                        validationErrors.add((ValidationError)new InvalidAttributeValue(configTypeName + ".content", content, (Object)"A config JSON document"));
                        continue;
                    }
                    LinkedHashMap<String, ConfigVar> contentMap = DocUtils.toStringKeyedMap((Map)((Map)content));
                    for (Map.Entry entry : contentMap.entrySet()) {
                        DocNode configEntry = DocNode.wrap(entry.getValue());
                        Object staticField = configEntry.get("static");
                        if (!Boolean.TRUE.equals(staticField)) continue;
                        validationErrors.add((ValidationError)new InvalidAttributeValue(configTypeName + ".content." + (String)entry.getKey(), entry.getValue(), (Object)"Non-static entry"));
                    }
                    if (ctype == CType.CONFIG_VARS) {
                        LinkedHashMap<String, ConfigVar> parsedContentMap = new LinkedHashMap<String, ConfigVar>(contentMap.size());
                        for (Map.Entry entry : contentMap.entrySet()) {
                            try {
                                parsedContentMap.put((String)entry.getKey(), new ConfigVar(DocNode.wrap(entry.getValue())));
                            }
                            catch (ConfigValidationException e) {
                                validationErrors.add(configTypeName + ".content." + (String)entry.getKey(), e);
                            }
                        }
                        contentMap = parsedContentMap;
                    }
                    String etag = ((Map)value).get("etag") != null ? String.valueOf(((Map)value).get("etag")) : null;
                    configTypeToConfigMap.put(ctype, new ConfigurationRepository.ConfigWithMetadata(contentMap, etag));
                }
                validationErrors.throwExceptionForPresentErrors();
                return configTypeToConfigMap;
            }
        }

        public static class Request
        extends Action.Request {
            private final UnparsedDocument<?> config;

            public Request(UnparsedDocument<?> config) {
                this.config = config;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                this.config = message.requiredUnparsedDoc();
            }

            public UnparsedDocument<?> getConfig() {
                return this.config;
            }

            public Object toBasicObject() {
                return this.config;
            }
        }
    }
}

