/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class LicenseHelper {
    public static String validateLicense(String licenseText) throws PGPException, SignatureException, IOException, ConfigValidationException {
        int ch;
        byte[] armoredPgp;
        licenseText = licenseText.trim().replaceAll("\\r|\\n", "");
        licenseText = licenseText.replace("---- SCHNIPP (Armored PGP signed JSON as base64) ----", "");
        licenseText = licenseText.replace("---- SCHNAPP ----", "");
        try {
            armoredPgp = BaseEncoding.base64().decode((CharSequence)licenseText);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigValidationException(new ValidationError(null, "Invalid base64 encoding").cause((Throwable)e));
        }
        ArmoredInputStream in = new ArmoredInputStream((InputStream)new ByteArrayInputStream(armoredPgp));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0 && in.isClearText()) {
            bout.write((byte)ch);
        }
        BcKeyFingerprintCalculator c = new BcKeyFingerprintCalculator();
        PGPObjectFactory factory = new PGPObjectFactory((InputStream)in, (KeyFingerPrintCalculator)c);
        PGPSignatureList sigL = (PGPSignatureList)factory.nextObject();
        PGPPublicKeyRingCollection pgpRings = new PGPPublicKeyRingCollection((InputStream)new ArmoredInputStream(LicenseHelper.class.getResourceAsStream("/KEYS")), (KeyFingerPrintCalculator)c);
        if (sigL == null || pgpRings == null || sigL.size() == 0 || pgpRings.size() == 0) {
            throw new PGPException("Cannot find license signature");
        }
        PGPSignature sig = sigL.get(0);
        PGPPublicKey publicKey = pgpRings.getPublicKey(sig.getKeyID());
        if (publicKey == null || sig == null) {
            throw new PGPException("license signature key mismatch");
        }
        sig.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
        ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
        ByteArrayInputStream sigIn = new ByteArrayInputStream(bout.toByteArray());
        int lookAhead = LicenseHelper.readInputLine(lineOut, sigIn);
        LicenseHelper.processLine(sig, lineOut.toByteArray());
        if (lookAhead != -1) {
            do {
                lookAhead = LicenseHelper.readInputLine(lineOut, lookAhead, sigIn);
                sig.update((byte)13);
                sig.update((byte)10);
                LicenseHelper.processLine(sig, lineOut.toByteArray());
            } while (lookAhead != -1);
        }
        if (!sig.verify()) {
            throw new PGPException("Invalid license signature");
        }
        return bout.toString();
    }

    private static int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) throws IOException {
        int ch;
        bOut.reset();
        int lookAhead = -1;
        while ((ch = fIn.read()) >= 0) {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = LicenseHelper.readPassedEOL(bOut, ch, fIn);
            break;
        }
        return lookAhead;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) throws IOException {
        bOut.reset();
        int ch = lookAhead;
        do {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = LicenseHelper.readPassedEOL(bOut, ch, fIn);
            break;
        } while ((ch = fIn.read()) >= 0);
        return lookAhead;
    }

    private static int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) throws IOException {
        int lookAhead = fIn.read();
        if (lastCh == 13 && lookAhead == 10) {
            bOut.write(lookAhead);
            lookAhead = fIn.read();
        }
        return lookAhead;
    }

    private static void processLine(PGPSignature sig, byte[] line) throws SignatureException, IOException {
        int length = LicenseHelper.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sig.update(line, 0, length);
        }
    }

    private static int getLengthWithoutWhiteSpace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && LicenseHelper.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isWhiteSpace(byte b) {
        return b == 13 || b == 10 || b == 9 || b == 32;
    }
}

