/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class SearchGuardLicense
implements Writeable,
Document<SearchGuardLicense> {
    private static final DateTimeFormatter DEFAULT_FOMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.ENGLISH);
    private static final int MAX_ALLOWED_DAYS_BEFORE_START_DAY = 30;
    private String uid;
    private Type type;
    private Feature[] features;
    private String issueDate;
    private String expiryDate;
    private String issuedTo;
    private String issuer;
    private String startDate;
    private Integer majorVersion;
    private String clusterName;
    private int allowedNodeCount;
    private List<String> msgs = new ArrayList<String>();
    private long expiresInDays = 0L;
    private boolean isExpired = true;
    private boolean valid = true;
    private String action;
    private String prodUsage;

    public static SearchGuardLicense createTrialLicense(String issueDate, String msg) {
        SearchGuardLicense trialLicense = new SearchGuardLicense("00000000-0000-0000-0000-000000000000", Type.TRIAL, Feature.values(), issueDate, SearchGuardLicense.addDays(issueDate, 60), "The world", "floragunn GmbH", issueDate, 7, "*", Integer.MAX_VALUE);
        if (msg != null) {
            trialLicense.msgs.add(msg);
        }
        return trialLicense;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uid);
        out.writeEnum((Enum)this.type);
        out.writeString(this.issueDate);
        out.writeString(this.expiryDate);
        out.writeString(this.issuedTo);
        out.writeString(this.issuer);
        out.writeString(this.startDate);
        out.writeOptionalVInt(this.majorVersion);
        out.writeString(this.clusterName);
        out.writeInt(this.allowedNodeCount);
        out.writeStringCollection(this.msgs);
        out.writeLong(this.expiresInDays);
        out.writeBoolean(this.isExpired);
        out.writeBoolean(this.valid);
        out.writeString(this.action);
        out.writeString(this.prodUsage);
        out.writeArray(StreamOutput::writeEnum, (Object[])(this.features == null ? new Feature[]{} : this.features));
    }

    public SearchGuardLicense(StreamInput in) throws IOException {
        this.uid = in.readString();
        this.type = (Type)in.readEnum(Type.class);
        this.issueDate = in.readString();
        this.expiryDate = in.readString();
        this.issuedTo = in.readString();
        this.issuer = in.readString();
        this.startDate = in.readString();
        this.majorVersion = in.readOptionalVInt();
        this.clusterName = in.readString();
        this.allowedNodeCount = in.readInt();
        this.msgs.addAll(in.readCollectionAsImmutableList(StreamInput::readString));
        this.expiresInDays = in.readLong();
        this.isExpired = in.readBoolean();
        this.valid = in.readBoolean();
        this.action = in.readString();
        this.prodUsage = in.readString();
        this.features = (Feature[])in.readArray((Writeable.Reader)new Writeable.Reader<Feature>(){

            public Feature read(StreamInput in) throws IOException {
                return (Feature)in.readEnum(Feature.class);
            }
        }, Feature[]::new);
    }

    public SearchGuardLicense(Map<String, Object> map) {
        this((String)(map == null ? null : map.get("uid")), map == null ? null : Type.valueOf(((String)map.get("type")).toUpperCase()), map == null ? null : SearchGuardLicense.parseFeatures((List)map.get("features")), (String)(map == null ? null : map.get("issued_date")), (String)(map == null ? null : map.get("expiry_date")), (String)(map == null ? null : map.get("issued_to")), (String)(map == null ? null : map.get("issuer")), (String)(map == null ? null : map.get("start_date")), (Integer)(map == null ? null : map.get("major_version")), (String)(map == null ? null : map.get("cluster_name")), (Integer)(map == null ? Integer.valueOf(0) : map.get("allowed_node_count_per_cluster")));
    }

    private static final Feature[] parseFeatures(List<?> featuresAsString) {
        if (featuresAsString == null || featuresAsString.isEmpty()) {
            return new Feature[0];
        }
        ArrayList<Feature> retVal = new ArrayList<Feature>();
        for (Object feature : featuresAsString) {
            try {
                retVal.add(Feature.valueOf(String.valueOf(feature).toUpperCase()));
            }
            catch (Exception exception) {}
        }
        return retVal.toArray(new Feature[0]);
    }

    public SearchGuardLicense(String uid, Type type, Feature[] features, String issueDate, String expiryDate, String issuedTo, String issuer, String startDate, Integer majorVersion, String clusterName, int allowedNodeCount) {
        this.uid = Objects.requireNonNull(uid);
        this.type = Objects.requireNonNull(type);
        this.features = features == null ? new Feature[]{} : (Feature[])features.clone();
        this.issueDate = Objects.requireNonNull(issueDate);
        this.expiryDate = Objects.requireNonNull(expiryDate);
        this.issuedTo = Objects.requireNonNull(issuedTo);
        this.issuer = Objects.requireNonNull(issuer);
        this.startDate = Objects.requireNonNull(startDate);
        this.majorVersion = Objects.requireNonNull(majorVersion);
        this.clusterName = Objects.requireNonNull(clusterName);
        this.allowedNodeCount = allowedNodeCount;
    }

    public ValidationErrors staticValidate() {
        ValidationErrors validationErrors = new ValidationErrors();
        LocalDate today = LocalDate.now();
        if (this.uid == null || this.uid.isEmpty()) {
            validationErrors.add((ValidationError)new MissingAttribute("uid"));
        }
        if (this.type == null) {
            validationErrors.add((ValidationError)new MissingAttribute("type"));
        }
        try {
            SearchGuardLicense.parseDate(this.issueDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            validationErrors.add(new InvalidAttributeValue("issued_date", (Object)this.issueDate, null).cause((Throwable)e));
        }
        try {
            LocalDate exd = SearchGuardLicense.parseDate(this.expiryDate);
            if (exd.isBefore(today)) {
                validationErrors.add(new ValidationError(null, "License is expired"));
            } else {
                this.isExpired = false;
                this.expiresInDays = SearchGuardLicense.diffDays(exd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            validationErrors.add(new InvalidAttributeValue("expiry_date", (Object)this.expiryDate, null).cause((Throwable)e));
        }
        if (this.issuedTo == null || this.issuedTo.isEmpty()) {
            validationErrors.add((ValidationError)new MissingAttribute("issued_to"));
        }
        if (this.issuer == null || this.issuer.isEmpty()) {
            validationErrors.add((ValidationError)new MissingAttribute("issuer"));
        }
        try {
            UUID.fromString(this.uid);
        }
        catch (Exception e) {
            validationErrors.add(new InvalidAttributeValue("uid", (Object)this.uid, null).cause((Throwable)e));
        }
        try {
            LocalDate parsedStartDate = SearchGuardLicense.parseDate(this.startDate);
            LocalDate earliestAllowedStartDate = parsedStartDate.minusDays(30L);
            if (today.isBefore(earliestAllowedStartDate)) {
                validationErrors.add(new ValidationError("start_date", "License cannot be applied earlier than " + DEFAULT_FOMATTER.format(earliestAllowedStartDate), (Object)this.startDate));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            validationErrors.add(new InvalidAttributeValue("start_date", (Object)this.startDate, null).cause((Throwable)e));
        }
        if (this.clusterName == null || this.clusterName.isEmpty()) {
            validationErrors.add((ValidationError)new MissingAttribute("cluster_name"));
        }
        return validationErrors;
    }

    public ValidationErrors dynamicValidate(ClusterService clusterService) {
        ValidationErrors validationErrors = this.staticValidate();
        int numberOfNodes = clusterService.state().getNodes().getSize();
        if (numberOfNodes > this.allowedNodeCount) {
            validationErrors.add(new ValidationError(null, "Only " + this.allowedNodeCount + " node(s) allowed but you run " + numberOfNodes + " node(s)"));
        }
        String nodes = this.allowedNodeCount > 1500 ? "unlimited" : String.valueOf(this.allowedNodeCount);
        boolean bl = this.valid = !validationErrors.hasErrors();
        if (!this.valid) {
            this.prodUsage = "No, because the license is not valid.";
            this.action = "Purchase a license. Visit docs.search-guard.com/latest/search-guard-enterprise-edition or write to <sales@floragunn.com>";
            this.msgs.clear();
            for (Map.Entry entry : validationErrors.getErrors().entrySet()) {
                if (((String)entry.getKey()).equals("_")) {
                    this.msgs.addAll(((Collection)entry.getValue()).stream().map(e -> e.getMessage()).collect(Collectors.toList()));
                    continue;
                }
                this.msgs.addAll(((Collection)entry.getValue()).stream().map(e -> (String)entry.getKey() + ": " + e.getMessage()).collect(Collectors.toList()));
            }
        } else {
            switch (this.type.ordinal()) {
                case 3: {
                    this.prodUsage = "Yes, unlimited clusters with all commercial features and " + nodes + " nodes per cluster for non-commercial academic and scientific use.";
                    break;
                }
                case 4: {
                    this.prodUsage = "Yes, for usage with bundled OEM products. Standalone usage is not permitted.";
                    break;
                }
                case 6: {
                    this.prodUsage = "Yes, unlimited clusters with all commercial features and " + nodes + " nodes per cluster for usage by '" + this.issuedTo + "'";
                    break;
                }
                default: {
                    this.prodUsage = "Yes, one cluster with all commercial features and " + nodes + " nodes per cluster.";
                }
            }
            this.action = "";
        }
        return validationErrors;
    }

    private static LocalDate parseDate(String date) {
        return LocalDate.parse(date, DEFAULT_FOMATTER);
    }

    private static String addDays(String date, int days) {
        LocalDate d = SearchGuardLicense.parseDate(date);
        return DEFAULT_FOMATTER.format(d.plus(Period.ofDays(days)));
    }

    private static long diffDays(LocalDate to) {
        return ChronoUnit.DAYS.between(LocalDate.now(), to);
    }

    public String getUid() {
        return this.uid;
    }

    public Type getType() {
        return this.type;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getIssuedTo() {
        return this.issuedTo;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<String> getMsgs() {
        return Collections.unmodifiableList(this.msgs);
    }

    public long getExpiresInDays() {
        return this.expiresInDays;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getAction() {
        return this.action;
    }

    public String getProdUsage() {
        return this.prodUsage;
    }

    public int getAllowedNodeCount() {
        return this.allowedNodeCount;
    }

    public Feature[] getFeatures() {
        return this.features == null ? null : (Feature[])this.features.clone();
    }

    public boolean hasFeature(Feature feature) {
        if (this.features == null || this.features.length == 0) {
            return false;
        }
        return Arrays.asList(this.features).contains((Object)feature);
    }

    public Object toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("uid", this.getUid());
        result.put("type", this.type != null ? this.type.toString() : null);
        if (this.features != null) {
            result.put("features", Arrays.asList(this.features).stream().map(e -> String.valueOf(e)).collect(Collectors.toList()));
        }
        result.put("issue_date", this.getIssueDate());
        result.put("expiry_date", this.getExpiryDate());
        result.put("issued_to", this.getIssuedTo());
        result.put("issuer", this.getIssuer());
        result.put("start_date", this.getStartDate());
        result.put("major_version", this.getMajorVersion());
        result.put("cluster_name", this.getClusterName());
        result.put("messages", this.msgs);
        result.put("expiry_in_days", this.getExpiresInDays());
        result.put("is_expired", this.isExpired);
        result.put("is_valid", this.valid);
        result.put("action", this.action);
        result.put("prod_usage", this.prodUsage);
        result.put("allowed_node_count_per_cluster", this.getAllowedNodeCount() > 1500 ? "unlimited" : String.valueOf(this.getAllowedNodeCount()));
        return result;
    }

    public String toString() {
        return "SearchGuardLicense [uid=" + this.uid + ", type=" + String.valueOf((Object)this.type) + ", features=" + Arrays.toString((Object[])this.features) + ", issueDate=" + this.issueDate + ", expiryDate=" + this.expiryDate + ", issuedTo=" + this.issuedTo + ", issuer=" + this.issuer + ", startDate=" + this.startDate + ", majorVersion=" + this.majorVersion + ", clusterName=" + this.clusterName + ", allowedNodeCount=" + this.allowedNodeCount + ", msgs=" + String.valueOf(this.msgs) + ", expiresInDays=" + this.expiresInDays + ", isExpired=" + this.isExpired + ", valid=" + this.valid + ", action=" + this.action + ", prodUsage=" + this.prodUsage + ", getMsgs()=" + String.valueOf(this.getMsgs()) + ", getExpiresInDays()=" + this.getExpiresInDays() + ", isExpired()=" + this.isExpired() + ", isValid()=" + this.isValid() + ", getAction()=" + this.getAction() + ", getProdUsage()=" + this.getProdUsage() + "]";
    }

    public static enum Type {
        FULL,
        SME,
        SINGLE,
        ACADEMIC,
        OEM,
        TRIAL,
        COMPANY;

    }

    public static enum Feature {
        COMPLIANCE;

    }
}

