/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthDomainInfo;
import com.floragunn.searchguard.user.UserInformation;
import com.jayway.jsonpath.JsonPath;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;

public final class AuthCredentials
implements UserInformation {
    private static final Logger log = LogManager.getLogger(AuthCredentials.class);
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private final String username;
    private final String subUserName;
    private final AuthDomainInfo authDomainInfo;
    private byte[] password;
    private Object nativeCredentials;
    private final ImmutableSet<String> backendRoles;
    private final ImmutableSet<String> searchGuardRoles;
    private boolean complete;
    private final boolean authzComplete;
    private final byte[] internalPasswordHash;
    private boolean secretsCleared;
    private Exception secretsClearedAt;
    private String redirectUri;
    private final Map<String, String> attributes;
    private final Map<String, Object> structuredAttributes;
    private final Map<String, Object> claims;
    private final ImmutableMap<String, Object> attributesForUserMapping;

    public static Builder forUser(String username) {
        return new Builder().userName(username);
    }

    private AuthCredentials(String username, String subUserName, AuthDomainInfo authDomainInfo, byte[] password, Object nativeCredentials, ImmutableSet<String> backendRoles, ImmutableSet<String> searchGuardRoles, boolean complete, boolean authzComplete, byte[] internalPasswordHash, Map<String, Object> structuredAttributes, Map<String, String> attributes, ImmutableMap<String, Object> attributesForUserMapping, Map<String, Object> claims, String redirectUri) {
        this.username = username;
        this.subUserName = subUserName;
        this.authDomainInfo = authDomainInfo;
        this.password = password;
        this.nativeCredentials = nativeCredentials;
        this.backendRoles = backendRoles;
        this.searchGuardRoles = searchGuardRoles;
        this.complete = complete;
        this.authzComplete = authzComplete;
        this.internalPasswordHash = internalPasswordHash;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.structuredAttributes = Collections.unmodifiableMap(structuredAttributes);
        this.attributesForUserMapping = attributesForUserMapping;
        this.claims = Collections.unmodifiableMap(claims);
        this.redirectUri = redirectUri;
    }

    @Deprecated
    public AuthCredentials(String username, Object nativeCredentials) {
        this(username, null, nativeCredentials, new String[0]);
        if (nativeCredentials == null) {
            throw new IllegalArgumentException("nativeCredentials must not be null or empty");
        }
    }

    @Deprecated
    public AuthCredentials(String username, byte[] password) {
        this(username, password, null, new String[0]);
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("password must not be null or empty");
        }
    }

    @Deprecated
    public AuthCredentials(String username, String ... backendRoles) {
        this(username, null, (Object)null, backendRoles);
    }

    @Deprecated
    private AuthCredentials(String username, byte[] password, Object nativeCredentials, String ... backendRoles) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("username must not be null or empty");
        }
        this.username = username;
        this.password = password == null ? null : Arrays.copyOf(password, password.length);
        this.subUserName = null;
        this.complete = false;
        this.authzComplete = false;
        this.authDomainInfo = AuthDomainInfo.UNKNOWN;
        if (this.password != null) {
            try {
                MessageDigest digester = MessageDigest.getInstance(DIGEST_ALGORITHM);
                this.internalPasswordHash = digester.digest(this.password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ElasticsearchSecurityException("Unable to digest password", (Exception)e, new Object[0]);
            }
        } else {
            this.internalPasswordHash = null;
        }
        if (password != null) {
            Arrays.fill(password, (byte)0);
            password = null;
        }
        this.nativeCredentials = nativeCredentials;
        nativeCredentials = null;
        this.backendRoles = backendRoles != null && backendRoles.length > 0 ? ImmutableSet.ofArray((Object[])backendRoles) : ImmutableSet.empty();
        this.searchGuardRoles = ImmutableSet.empty();
        this.attributesForUserMapping = ImmutableMap.empty();
        this.attributes = new HashMap<String, String>();
        this.structuredAttributes = new HashMap<String, Object>();
        this.claims = new HashMap<String, Object>();
    }

    public void clearSecrets() {
        if (this.secretsCleared) {
            return;
        }
        this.secretsCleared = true;
        if (log.isDebugEnabled()) {
            this.secretsClearedAt = new Exception("clearSecrets() called at:");
        }
        if (this.password != null) {
            Arrays.fill(this.password, (byte)0);
            this.password = null;
        }
        this.nativeCredentials = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSubUserName() {
        return this.subUserName;
    }

    public byte[] getPassword() {
        if (this.secretsCleared) {
            throw new IllegalStateException("Secrets for " + String.valueOf(this) + " have been already cleared", this.secretsClearedAt);
        }
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    public Object getNativeCredentials() {
        return this.nativeCredentials;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.internalPasswordHash);
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.subUserName == null ? 0 : this.subUserName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthCredentials other = (AuthCredentials)obj;
        if (this.internalPasswordHash == null || other.internalPasswordHash == null || !MessageDigest.isEqual(this.internalPasswordHash, other.internalPasswordHash)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.subUserName == null ? other.subUserName != null : !this.subUserName.equals(other.subUserName));
    }

    public Set<String> getBackendRoles() {
        return this.backendRoles;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isAuthzComplete() {
        return this.authzComplete;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public AuthCredentials userName(String newUserName) {
        return new AuthCredentials(newUserName, this.subUserName, this.authDomainInfo, this.password, this.nativeCredentials, this.backendRoles, this.searchGuardRoles, this.complete, this.authzComplete, this.internalPasswordHash, this.structuredAttributes, this.attributes, this.attributesForUserMapping, this.claims, this.redirectUri);
    }

    public AuthCredentials with(AuthCredentials other) {
        if (other == this || other == null) {
            return this;
        }
        return new AuthCredentials(this.username, this.subUserName, this.authDomainInfo, this.password, this.nativeCredentials, (ImmutableSet<String>)this.backendRoles.with(other.backendRoles), (ImmutableSet<String>)this.searchGuardRoles.with(other.searchGuardRoles), this.complete, this.authzComplete, this.internalPasswordHash, (Map<String, Object>)AuthCredentials.mergeMaps(this.structuredAttributes, other.structuredAttributes), this.attributes, AuthCredentials.mergeMaps(this.attributesForUserMapping, other.attributesForUserMapping), this.claims, this.redirectUri);
    }

    public AuthCredentials with(AuthDomainInfo authDomainInfo) {
        return new AuthCredentials(this.username, this.subUserName, authDomainInfo, this.password, this.nativeCredentials, this.backendRoles, this.searchGuardRoles, this.complete, this.authzComplete, this.internalPasswordHash, this.structuredAttributes, this.attributes, this.attributesForUserMapping, this.claims, this.redirectUri);
    }

    public Builder copy() {
        return new Builder(this);
    }

    @Deprecated
    public AuthCredentials markComplete() {
        this.complete = true;
        return this;
    }

    @Deprecated
    public void addAttribute(String name, String value) {
        if (name != null && !name.isEmpty()) {
            this.attributes.put(name, value);
        }
    }

    public Map<String, Object> getStructuredAttributes() {
        return this.structuredAttributes;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public AuthDomainInfo getAuthDomainInfo() {
        return this.authDomainInfo;
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public String getSubName() {
        return this.subUserName;
    }

    @Override
    public String getAuthDomain() {
        return this.authDomainInfo != null ? this.authDomainInfo.toInfoString() : null;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public ImmutableMap<String, Object> getAttributesForUserMapping() {
        return this.attributesForUserMapping;
    }

    public AuthCredentials userMappingAttributes(ImmutableMap<String, Object> attributesForUserMapping) {
        return new AuthCredentials(this.username, this.subUserName, this.authDomainInfo, this.password, this.nativeCredentials, this.backendRoles, this.searchGuardRoles, this.complete, this.authzComplete, this.internalPasswordHash, this.structuredAttributes, this.attributes, (ImmutableMap<String, Object>)this.attributesForUserMapping.with(attributesForUserMapping), this.claims, this.redirectUri);
    }

    public AuthCredentials userMappingAttribute(String key, Object value) {
        return new AuthCredentials(this.username, this.subUserName, this.authDomainInfo, this.password, this.nativeCredentials, this.backendRoles, this.searchGuardRoles, this.complete, this.authzComplete, this.internalPasswordHash, this.structuredAttributes, this.attributes, (ImmutableMap<String, Object>)this.attributesForUserMapping.with((Object)key, value), this.claims, this.redirectUri);
    }

    public ImmutableSet<String> getSearchGuardRoles() {
        return this.searchGuardRoles;
    }

    public String toString() {
        return "AuthCredentials [username=" + this.username + ", subUserName=" + this.subUserName + ", authDomainInfo=" + String.valueOf(this.authDomainInfo) + ", password=" + (this.password != null ? "REDACTED" : null) + ", nativeCredentials=" + (this.nativeCredentials != null ? "REDACTED" : null) + ", backendRoles=" + String.valueOf(this.backendRoles) + ", searchGuardRoles=" + String.valueOf(this.searchGuardRoles) + ", complete=" + this.complete + ", authzComplete=" + this.authzComplete + ", redirectUri=" + this.redirectUri + ", attributes=" + String.valueOf(this.attributes) + ", structuredAttributes=" + String.valueOf(this.structuredAttributes) + ", claims=" + String.valueOf(this.claims) + ", attributesForUserMapping=" + String.valueOf(this.attributesForUserMapping) + "]";
    }

    private static ImmutableMap<String, Object> mergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        if (map2 == null || map2.size() == 0) {
            return ImmutableMap.of(map1);
        }
        if (map1 == null || map1.size() == 0) {
            return ImmutableMap.of(map2);
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder(map1);
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String key = entry.getKey();
            Object value2 = entry.getValue();
            Object value1 = result.get((Object)key);
            if (value1 == null) {
                result.put((Object)key, value2);
                continue;
            }
            if (value1 instanceof Collection && value2 instanceof Collection) {
                if (value1 instanceof Set) {
                    result.put((Object)key, (Object)ImmutableSet.of((Collection)((Collection)value1)).with((Collection)value2));
                    continue;
                }
                result.put((Object)key, (Object)ImmutableList.of((Collection)((Collection)value1)).with((Object)((Collection)value2)));
                continue;
            }
            if (!(value1 instanceof Map) || !(value2 instanceof Map)) continue;
            result.put((Object)key, AuthCredentials.mergeMaps((Map)value1, (Map)value2));
        }
        return result.build();
    }

    public static class Builder {
        private String userName;
        private String subUserName;
        private AuthDomainInfo authDomainInfo = AuthDomainInfo.UNKNOWN;
        private byte[] password;
        private Object nativeCredentials;
        private ImmutableSet.Builder<String> backendRoles;
        private ImmutableSet.Builder<String> searchGuardRoles;
        private boolean complete;
        private boolean authzComplete;
        private byte[] internalPasswordHash;
        private ImmutableMap.Builder<String, String> attributes;
        private ImmutableMap.Builder<String, Object> structuredAttributes;
        private ImmutableMap.Builder<String, Object> attributesForUserMapping;
        private ImmutableMap.Builder<String, Object> claims;
        private String redirectUri;

        public Builder() {
            this.backendRoles = new ImmutableSet.Builder();
            this.searchGuardRoles = new ImmutableSet.Builder();
            this.structuredAttributes = new ImmutableMap.Builder();
            this.attributes = new ImmutableMap.Builder();
            this.claims = new ImmutableMap.Builder();
            this.attributesForUserMapping = new ImmutableMap.Builder();
        }

        Builder(AuthCredentials authCredentials) {
            this.userName = authCredentials.username;
            this.subUserName = authCredentials.subUserName;
            this.password = authCredentials.password;
            this.backendRoles = new ImmutableSet.Builder(authCredentials.backendRoles);
            this.searchGuardRoles = new ImmutableSet.Builder(authCredentials.searchGuardRoles);
            this.complete = authCredentials.complete;
            this.internalPasswordHash = authCredentials.internalPasswordHash;
            this.attributes = new ImmutableMap.Builder(authCredentials.attributes);
            this.structuredAttributes = new ImmutableMap.Builder(authCredentials.structuredAttributes);
            this.attributesForUserMapping = new ImmutableMap.Builder(authCredentials.attributesForUserMapping);
            this.authDomainInfo = authCredentials.authDomainInfo;
            this.redirectUri = authCredentials.redirectUri;
            this.claims = new ImmutableMap.Builder(authCredentials.claims);
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.attributesForUserMapping.with((Object)"credentials", (Object)ImmutableMap.of((Object)"user_name", (Object)userName));
            return this;
        }

        public Builder subUserName(String subUserName) {
            this.subUserName = subUserName;
            return this;
        }

        public Builder password(byte[] password) {
            if (password == null || password.length == 0) {
                throw new IllegalArgumentException("password must not be null or empty");
            }
            this.password = Arrays.copyOf(password, password.length);
            try {
                MessageDigest digester = MessageDigest.getInstance(AuthCredentials.DIGEST_ALGORITHM);
                this.internalPasswordHash = digester.digest(this.password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ElasticsearchSecurityException("Unable to digest password", (Exception)e, new Object[0]);
            }
            Arrays.fill(password, (byte)0);
            return this;
        }

        public Builder password(String password) {
            return this.password(password.getBytes(StandardCharsets.UTF_8));
        }

        public Builder nativeCredentials(Object nativeCredentials) {
            if (nativeCredentials == null) {
                throw new IllegalArgumentException("nativeCredentials must not be null or empty");
            }
            this.nativeCredentials = nativeCredentials;
            return this;
        }

        public Builder backendRoles(String ... backendRoles) {
            if (backendRoles == null) {
                return this;
            }
            this.backendRoles.addAll((Object[])backendRoles);
            return this;
        }

        public Builder backendRoles(Collection<String> backendRoles) {
            if (backendRoles == null) {
                return this;
            }
            this.backendRoles.addAll(backendRoles);
            return this;
        }

        public Builder searchGuardRoles(Collection<String> searchGuardRoles) {
            if (this.backendRoles == null) {
                return this;
            }
            this.searchGuardRoles.addAll(searchGuardRoles);
            return this;
        }

        public Builder complete() {
            this.complete = true;
            return this;
        }

        public Builder oldAttribute(String name, String value) {
            if (name != null && !name.isEmpty()) {
                this.attributes.put((Object)name, (Object)value);
            }
            return this;
        }

        public Builder authzComplete() {
            this.authzComplete = true;
            return this;
        }

        public Builder oldAttributes(Map<String, String> map) {
            this.attributes.putAll(map);
            return this;
        }

        public Builder prefixOldAttributes(String keyPrefix, Map<String, ?> map) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.attributes.put((Object)(keyPrefix + entry.getKey()), entry.getValue() != null ? entry.getValue().toString() : null);
            }
            return this;
        }

        public Builder attribute(String name, Object value) {
            Attributes.validate(value);
            if (name != null && !name.isEmpty()) {
                this.structuredAttributes.put((Object)name, value);
            }
            return this;
        }

        public Builder attributes(Map<String, Object> map) {
            Attributes.validate(map);
            this.structuredAttributes.putAll(map);
            return this;
        }

        public Builder attributesByJsonPath(Map<String, JsonPath> jsonPathMap, Object source) {
            Attributes.addAttributesByJsonPath(jsonPathMap, source, this.structuredAttributes);
            return this;
        }

        public Builder userMappingAttribute(String name, Object value) {
            if (name != null && !name.isEmpty()) {
                this.attributesForUserMapping.with((Object)name, value);
            }
            return this;
        }

        public Builder claims(Map<String, Object> map) {
            this.claims.putAll(map);
            return this;
        }

        public Builder authenticatorType(String authDomainType) {
            this.authDomainInfo = this.authDomainInfo.authenticatorType(authDomainType);
            return this;
        }

        public Builder authDomainInfo(AuthDomainInfo authDomainInfo) {
            this.authDomainInfo = this.authDomainInfo.add(authDomainInfo);
            return this;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthCredentials build() {
            AuthCredentials result = new AuthCredentials(this.userName, this.subUserName, this.authDomainInfo, this.password, this.nativeCredentials, (ImmutableSet<String>)this.backendRoles.build(), (ImmutableSet<String>)this.searchGuardRoles.build(), this.complete, this.authzComplete, this.internalPasswordHash, (Map<String, Object>)this.structuredAttributes.build(), (Map<String, String>)this.attributes.build(), (ImmutableMap<String, Object>)this.attributesForUserMapping.build(), (Map<String, Object>)this.claims.build(), this.redirectUri);
            this.password = null;
            this.nativeCredentials = null;
            this.internalPasswordHash = null;
            return result;
        }
    }
}

