/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RoleNames
implements ToXContentObject {
    private final Set<String> backendRoles;
    private final Set<String> searchGuardRoles;

    public RoleNames(Set<String> backendRoles, Set<String> searchGuardRoles) {
        this.backendRoles = Collections.unmodifiableSet(backendRoles);
        this.searchGuardRoles = Collections.unmodifiableSet(searchGuardRoles);
    }

    public Set<String> getBackendRoles() {
        return this.backendRoles;
    }

    public Set<String> getSearchGuardRoles() {
        return this.searchGuardRoles;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.backendRoles.isEmpty()) {
            builder.field("be", this.backendRoles);
        }
        if (!this.searchGuardRoles.isEmpty()) {
            builder.field("sg", this.searchGuardRoles);
        }
        builder.endObject();
        return builder;
    }
}

