/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.patch;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocUpdateException;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.documents.pointer.JsonPointer;
import com.floragunn.codova.documents.pointer.PointerEvaluationException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class JsonPatch
implements DocPatch {
    public static final String MEDIA_TYPE = "application/json-patch+json";
    private ImmutableList<Operation> operations;

    public JsonPatch(Operation ... operations) {
        this.operations = ImmutableList.ofArray((Object[])operations);
    }

    JsonPatch(ImmutableList<Operation> operations) {
        this.operations = operations;
    }

    JsonPatch(DocNode source) throws ConfigValidationException {
        ArrayList<Operation> operations;
        ValidationErrors validationErrors;
        if (source.isList()) {
            validationErrors = new ValidationErrors();
            int i = 0;
            operations = new ArrayList<Operation>();
            for (DocNode element : source.toListOfNodes()) {
                try {
                    operations.add(Operation.parse(element));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(String.valueOf(i), e);
                }
                ++i;
            }
        } else {
            throw new ConfigValidationException(new InvalidAttributeValue(null, source, (Object)"An array of operations"));
        }
        validationErrors.throwExceptionForPresentErrors();
        this.operations = ImmutableList.of(operations);
    }

    @Override
    public Object toBasicObject() {
        return this.operations;
    }

    @Override
    public DocNode apply(DocNode targetDocument) throws DocUpdateException {
        Object document = JsonPatch.createMutableCopy(targetDocument.toBasicObject());
        int i = 0;
        for (Operation operation : this.operations) {
            try {
                if (operation instanceof Operation.Replace && ((Operation.Replace)operation).pointer.isRoot()) {
                    document = JsonPatch.createMutableCopy(((Operation.Replace)operation).value);
                } else if (!operation.apply(document)) {
                    return targetDocument;
                }
            }
            catch (PointerEvaluationException e) {
                throw new DocUpdateException("Error while applying operation " + i + ": " + e.getMessage(), e);
            }
            ++i;
        }
        return DocNode.wrap(document);
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }

    private static Object createMutableCopy(Object object) {
        if (object instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(String.valueOf(entry.getKey()), JsonPatch.createMutableCopy(entry.getValue()));
            }
            return result;
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>(((Collection)object).size());
            for (Object element : (Collection)object) {
                result.add(JsonPatch.createMutableCopy(element));
            }
            return result;
        }
        return object;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonPatch)) {
            return false;
        }
        JsonPatch other = (JsonPatch)obj;
        return !(this.operations == null ? other.operations != null : !this.operations.equals(other.operations));
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public static JsonPatch fromDiff(DocNode source, DocNode target) {
        if (source == null) {
            source = DocNode.NULL;
        }
        if (target == null) {
            target = DocNode.NULL;
        }
        if (source.isNull() && target.isNull()) {
            return new JsonPatch(new Operation[0]);
        }
        if (source.isNull()) {
            return new JsonPatch(new Operation.Replace(JsonPointer.ROOT, target.toBasicObject()));
        }
        if (target.isNull()) {
            return new JsonPatch(new Operation.Replace(JsonPointer.ROOT, null));
        }
        if (source.isMap() && target.isMap()) {
            ImmutableList.Builder result = new ImmutableList.Builder();
            JsonPatch.diff(JsonPointer.ROOT, source.toMap(), target.toMap(), (ImmutableList.Builder<Operation>)result);
            return new JsonPatch((ImmutableList<Operation>)result.build());
        }
        if (source.isList() && target.isList()) {
            return new JsonPatch(new Operation.Replace(JsonPointer.ROOT, target.toBasicObject()));
        }
        return new JsonPatch(new Operation.Replace(JsonPointer.ROOT, target.toBasicObject()));
    }

    private static void diff(JsonPointer pointer, Map<?, ?> source, Map<?, ?> target, ImmutableList.Builder<Operation> result) {
        for (Map.Entry<?, ?> sourceEntry : source.entrySet()) {
            Object key = sourceEntry.getKey();
            Object sourceValue = sourceEntry.getValue();
            Object targetValue = target.get(key);
            if (sourceValue instanceof DocNode) {
                sourceValue = ((DocNode)sourceValue).toBasicObject();
            }
            if (targetValue instanceof DocNode) {
                targetValue = ((DocNode)targetValue).toBasicObject();
            }
            if (Objects.equals(sourceValue, targetValue)) continue;
            if (targetValue == null) {
                result.add((Object)new Operation.Remove(pointer.with(key.toString())));
                continue;
            }
            if (JsonPatch.isScalar(targetValue)) {
                result.add((Object)new Operation.Replace(pointer.with(key.toString()), targetValue));
                continue;
            }
            if (JsonPatch.isScalar(sourceValue)) {
                result.add((Object)new Operation.Replace(pointer.with(key.toString()), targetValue));
                continue;
            }
            if (sourceValue instanceof Map && targetValue instanceof Map) {
                if (JsonPatch.isAnyElementEqual((Map)sourceValue, (Map)targetValue)) {
                    JsonPatch.diff(pointer.with(key.toString()), (Map)sourceValue, (Map)targetValue, result);
                    continue;
                }
                result.add((Object)new Operation.Replace(pointer.with(key.toString()), targetValue));
                continue;
            }
            if (sourceValue instanceof Collection && targetValue instanceof Collection) {
                result.add((Object)new Operation.Replace(pointer.with(key.toString()), targetValue));
                continue;
            }
            result.add((Object)new Operation.Replace(pointer.with(key.toString()), targetValue));
        }
        for (Map.Entry<Object, Object> key : target.keySet()) {
            if (source.containsKey(key)) continue;
            Object targetValue = target.get(key);
            result.add((Object)new Operation.Add(pointer.with(key.toString()), targetValue));
        }
    }

    private static boolean isScalar(Object o) {
        return !(o instanceof Map) && !(o instanceof Collection);
    }

    private static boolean isAnyElementEqual(Map<?, ?> source, Map<?, ?> target) {
        for (Map.Entry<?, ?> sourceEntry : source.entrySet()) {
            Object key = sourceEntry.getKey();
            Object sourceValue = sourceEntry.getValue();
            Object targetValue = target.get(key);
            if (sourceValue instanceof DocNode) {
                sourceValue = ((DocNode)sourceValue).toBasicObject();
            }
            if (targetValue instanceof DocNode) {
                targetValue = ((DocNode)targetValue).toBasicObject();
            }
            if (!(sourceValue instanceof Map && targetValue instanceof Map ? JsonPatch.isAnyElementEqual((Map)sourceValue, (Map)targetValue) : Objects.equals(sourceValue, targetValue))) continue;
            return true;
        }
        return false;
    }

    public static interface Operation {
        public boolean apply(Object var1) throws PointerEvaluationException;

        public static Operation parse(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            String operation = vNode.get("op").required().asString();
            validationErrors.throwExceptionForPresentErrors();
            switch (operation.toLowerCase()) {
                case "add": {
                    return new Add(vNode);
                }
                case "remove": {
                    return new Remove(vNode);
                }
                case "replace": {
                    return new Replace(vNode);
                }
                case "move": {
                    return new Move(vNode);
                }
                case "copy": {
                    return new Copy(vNode);
                }
                case "test": {
                    return new Test(vNode);
                }
            }
            throw new ConfigValidationException(new InvalidAttributeValue("op", (Object)operation, (Object)"add|remove|replace|move|test"));
        }

        public static class Test
        implements Operation,
        Document<Test> {
            private final JsonPointer pointer;
            private final Object value;

            Test(ValidatingDocNode vNode) throws ConfigValidationException {
                this.pointer = vNode.get("path").required().byString(JsonPointer::parse);
                this.value = vNode.get("value").required().asAnything();
                vNode.throwExceptionForPresentErrors();
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"test", (Object)"path", (Object)this.pointer.toString(), (Object)"value", (Object)this.value);
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                Object currentValue = this.pointer.getPointedValue(document);
                return Objects.equals(this.value, currentValue);
            }
        }

        public static class Copy
        implements Operation,
        Document<Copy> {
            private final JsonPointer from;
            private final JsonPointer to;

            Copy(ValidatingDocNode vNode) throws ConfigValidationException {
                this.from = vNode.get("from").required().byString(JsonPointer::parse);
                this.to = vNode.get("path").required().byString(JsonPointer::parse);
                vNode.throwExceptionForPresentErrors();
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"copy", (Object)"from", (Object)this.from.toString(), (Object)"path", (Object)this.to.toString());
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                Object value = this.from.getPointedValue(document);
                this.to.addAtPointedValue(document, JsonPatch.createMutableCopy(value));
                return true;
            }
        }

        public static class Move
        implements Operation,
        Document<Move> {
            private final JsonPointer from;
            private final JsonPointer to;

            Move(ValidatingDocNode vNode) throws ConfigValidationException {
                this.from = vNode.get("from").required().byString(JsonPointer::parse);
                this.to = vNode.get("path").required().byString(JsonPointer::parse);
                vNode.throwExceptionForPresentErrors();
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"move", (Object)"from", (Object)this.from.toString(), (Object)"path", (Object)this.to.toString());
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                Object value = this.from.removePointedValue(document);
                this.to.addAtPointedValue(document, value);
                return true;
            }
        }

        public static class Replace
        implements Operation,
        Document<Replace> {
            private final JsonPointer pointer;
            private final Object value;

            Replace(ValidatingDocNode vNode) throws ConfigValidationException {
                this.pointer = vNode.get("path").required().byString(JsonPointer::parse);
                this.value = vNode.get("value").required().asAnything();
                vNode.throwExceptionForPresentErrors();
            }

            Replace(JsonPointer pointer, Object value) {
                this.pointer = pointer;
                this.value = value;
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)this.pointer.toString(), (Object)"value", (Object)this.value);
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                this.pointer.setPointedValue(document, this.value);
                return true;
            }
        }

        public static class Remove
        implements Operation,
        Document<Remove> {
            private final JsonPointer pointer;

            Remove(ValidatingDocNode vNode) throws ConfigValidationException {
                this.pointer = vNode.get("path").required().byString(JsonPointer::parse);
                vNode.throwExceptionForPresentErrors();
            }

            Remove(JsonPointer pointer) {
                this.pointer = pointer;
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"remove", (Object)"path", (Object)this.pointer.toString());
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                this.pointer.removePointedValue(document);
                return true;
            }
        }

        public static class Add
        implements Operation,
        Document<Add> {
            private final JsonPointer pointer;
            private final Object value;

            Add(ValidatingDocNode vNode) throws ConfigValidationException {
                this.pointer = vNode.get("path").required().byString(JsonPointer::parse);
                this.value = vNode.get("value").required().asAnything();
                vNode.throwExceptionForPresentErrors();
            }

            Add(JsonPointer pointer, Object value) {
                this.pointer = pointer;
                this.value = value;
            }

            @Override
            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"op", (Object)"add", (Object)"path", (Object)this.pointer.toString(), (Object)"value", (Object)this.value);
            }

            @Override
            public boolean apply(Object document) throws PointerEvaluationException {
                this.pointer.addAtPointedValue(document, this.value);
                return true;
            }
        }
    }
}

