/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidNullException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.JsonValidationError;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.UnsupportedAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import java.util.List;

public class JacksonExceptions {
    public static ValidationError toValidationError(IllegalArgumentException e) {
        if (e.getCause() instanceof JsonMappingException) {
            return JacksonExceptions.toValidationError((JsonMappingException)e.getCause());
        }
        if (e.getCause() instanceof JsonProcessingException) {
            return JacksonExceptions.toValidationError((JsonProcessingException)e.getCause());
        }
        throw e;
    }

    public static ValidationError toValidationError(JsonMappingException e) {
        String path = JacksonExceptions.getPathAsString(e.getPath());
        if (e instanceof UnrecognizedPropertyException) {
            return new UnsupportedAttribute(path, (Object)null, null).cause((Throwable)e);
        }
        if (e instanceof InvalidNullException) {
            return new MissingAttribute(path).cause((Throwable)e);
        }
        if (e instanceof MismatchedInputException) {
            return new InvalidAttributeValue(path, (Object)null, (Object)((MismatchedInputException)e).getTargetType()).cause((Throwable)e);
        }
        return new ValidationError(path, e.getMessage()).cause((Throwable)e);
    }

    public static ValidationError toValidationError(JsonProcessingException e) {
        return new JsonValidationError(null, e);
    }

    public static ConfigValidationException toConfigValidationException(IllegalArgumentException e) {
        return new ConfigValidationException(JacksonExceptions.toValidationError(e));
    }

    public static ConfigValidationException toConfigValidationException(JsonMappingException e) {
        return new ConfigValidationException(JacksonExceptions.toValidationError(e));
    }

    private static String getPathAsString(List<JsonMappingException.Reference> path) {
        StringBuilder result = new StringBuilder();
        for (JsonMappingException.Reference reference : path) {
            if (result.length() != 0) {
                result.append('.');
            }
            if (reference.getFieldName() != null) {
                result.append(reference.getFieldName());
                continue;
            }
            if (reference.getIndex() == -1) continue;
            result.append(reference.getIndex());
        }
        return result.toString();
    }
}

