/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util.config;

import com.floragunn.searchguard.ssl.util.config.ClientAuthCredentials;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfigException;
import com.floragunn.searchguard.ssl.util.config.TrustStore;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

public class GenericSSLConfig {
    private static final List<String> DEFAULT_TLS_PROTOCOLS = ImmutableList.of((Object)"TLSv1.2", (Object)"TLSv1.1");
    private String[] enabledProtocols;
    private String[] enabledCiphers;
    private HostnameVerifier hostnameVerifier;
    private boolean hostnameVerificationEnabled;
    private boolean trustAll;
    private SSLContext sslContext;

    public SSLContext getUnrestrictedSslContext() {
        return this.sslContext;
    }

    public RestrictingSSLSocketFactory getRestrictedSSLSocketFactory() {
        return new RestrictingSSLSocketFactory(this.sslContext.getSocketFactory(), this.enabledProtocols, this.enabledCiphers);
    }

    public SSLIOSessionStrategy toSSLIOSessionStrategy() {
        return new SSLIOSessionStrategy(this.sslContext, this.enabledProtocols, this.enabledCiphers, this.hostnameVerifier);
    }

    public SSLConnectionSocketFactory toSSLConnectionSocketFactory() {
        return new SSLConnectionSocketFactory(this.sslContext, this.enabledProtocols, this.enabledCiphers, this.hostnameVerifier);
    }

    private static class RestrictingSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final String[] enabledProtocols;
        private final String[] enabledCipherSuites;

        public RestrictingSSLSocketFactory(SSLSocketFactory delegate, String[] enabledProtocols, String[] enabledCipherSuites) {
            this.delegate = delegate;
            this.enabledProtocols = enabledProtocols;
            this.enabledCipherSuites = enabledCipherSuites;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.enabledCipherSuites == null ? this.delegate.getDefaultCipherSuites() : this.enabledCipherSuites;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.enabledCipherSuites == null ? this.delegate.getSupportedCipherSuites() : this.enabledCipherSuites;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.enforce(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.enforce(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.enforce(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.enforce(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.enforce(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.enforce(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        private Socket enforce(Socket socket) {
            if (socket != null && socket instanceof SSLSocket) {
                if (this.enabledProtocols != null) {
                    ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
                }
                if (this.enabledCipherSuites != null) {
                    ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCipherSuites);
                }
            }
            return socket;
        }
    }

    private static class PrivateKeySelector
    implements PrivateKeyStrategy {
        private final String effectiveKeyAlias;

        PrivateKeySelector(String effectiveKeyAlias) {
            this.effectiveKeyAlias = effectiveKeyAlias;
        }

        public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
            if (aliases == null || aliases.isEmpty()) {
                return this.effectiveKeyAlias;
            }
            if (this.effectiveKeyAlias == null || this.effectiveKeyAlias.isEmpty()) {
                return aliases.keySet().iterator().next();
            }
            return this.effectiveKeyAlias;
        }
    }

    private static class OverlyTrustfulTrustManager
    implements X509TrustManager {
        private OverlyTrustfulTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class OverlyTrustfulSSLContextBuilder
    extends SSLContextBuilder {
        private OverlyTrustfulSSLContextBuilder() {
        }

        protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            sslContext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[keyManagers.size()]) : null, new TrustManager[]{new OverlyTrustfulTrustManager()}, secureRandom);
        }
    }

    public static class Builder {
        private GenericSSLConfig result = new GenericSSLConfig();
        private ClientAuthCredentials clientAuthCredentials;
        private TrustStore trustStore;
        private String clientName;

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder verifyHostnames(boolean hostnameVerificationEnabled) {
            this.result.hostnameVerificationEnabled = hostnameVerificationEnabled;
            return this;
        }

        public Builder trustAll(boolean trustAll) {
            this.result.trustAll = trustAll;
            return this;
        }

        public Builder useCiphers(String ... enabledCiphers) {
            this.result.enabledCiphers = enabledCiphers;
            return this;
        }

        public Builder useProtocols(String ... enabledProtocols) {
            this.result.enabledProtocols = enabledProtocols;
            return this;
        }

        public Builder useClientAuth(ClientAuthCredentials clientAuthCredentials) {
            this.clientAuthCredentials = clientAuthCredentials;
            return this;
        }

        public Builder useTrustStore(TrustStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public GenericSSLConfig build() throws GenericSSLConfigException {
            this.result.hostnameVerifier = this.result.hostnameVerificationEnabled ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
            if (this.result.enabledProtocols == null) {
                this.result.enabledProtocols = DEFAULT_TLS_PROTOCOLS.toArray(new String[0]);
            }
            this.result.sslContext = this.buildSSLContext();
            return this.result;
        }

        public SSLIOSessionStrategy toSSLIOSessionStrategy() throws GenericSSLConfigException {
            return this.build().toSSLIOSessionStrategy();
        }

        public SSLConnectionSocketFactory toSSLConnectionSocketFactory() throws GenericSSLConfigException {
            return this.build().toSSLConnectionSocketFactory();
        }

        SSLContext buildSSLContext() throws GenericSSLConfigException {
            try {
                SSLContextBuilder sslContextBuilder = this.result.trustAll ? new OverlyTrustfulSSLContextBuilder() : SSLContexts.custom();
                if (this.trustStore != null) {
                    sslContextBuilder.loadTrustMaterial(this.trustStore.getKeyStore(), null);
                }
                if (this.clientAuthCredentials != null) {
                    sslContextBuilder.loadKeyMaterial(this.clientAuthCredentials.getKeyStore(), this.clientAuthCredentials.getKeyPassword(), (PrivateKeyStrategy)new PrivateKeySelector(this.clientAuthCredentials.getKeyAlias()));
                }
                return sslContextBuilder.build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new GenericSSLConfigException("Error while initializing SSL configuration for " + this.clientName, e);
            }
        }
    }
}

