/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.unboundid.ldap.sdk.Filter;
import java.util.HashMap;
import java.util.Map;

public class ParametrizedFilter {
    private final String filter;
    private final Map<Integer, String> placeholders = new HashMap<Integer, String>();

    public ParametrizedFilter(String filter) {
        this.filter = filter;
    }

    public void setParameter(int placeholder, String value) {
        if (value != null) {
            this.placeholders.put(placeholder, value);
        }
    }

    public String toString() {
        if (this.filter == null) {
            return null;
        }
        String f = this.filter;
        for (Map.Entry<Integer, String> placeholder : this.placeholders.entrySet()) {
            f = f.replace("{" + placeholder.getKey() + "}", this.encode(placeholder.getValue()));
        }
        return f;
    }

    private String encode(String value) {
        return Filter.encodeValue((String)value);
    }
}

