/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidators;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.api.PatchableResourceApiAction;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.dlic.rest.validation.SgConfigValidator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class SgConfigAction
extends PatchableResourceApiAction {
    private final boolean allowPutOrPatch;

    @Inject
    public SgConfigAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog, ConfigModificationValidators configModificationValidators) {
        super(settings, configPath, controller, client, adminDNs, cl, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditLog, configModificationValidators);
        this.allowPutOrPatch = settings.getAsBoolean("searchguard.unsupported.restapi.allow_sgconfig_modification", Boolean.valueOf(false));
    }

    public List<RestHandler.Route> routes() {
        if (this.allowPutOrPatch) {
            return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/sgconfig/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/sg_config/"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/sg_config/"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/sgconfig/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_searchguard/api/sgconfig/"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/sg_config/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_searchguard/api/sg_config/"));
        }
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/sgconfig/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/sg_config/"));
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        try {
            Object configuration = this.load(this.getConfigName(), true);
            configuration = this.filter((SgDynamicConfiguration<?>)configuration);
            this.successResponse(channel, (SgDynamicConfiguration<?>)configuration);
        }
        catch (ConfigUnavailableException e) {
            this.internalErrorResponse(channel, e.getMessage());
            return;
        }
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client, BytesReference content) throws IOException {
        if (request.method() == RestRequest.Method.PATCH && !this.allowPutOrPatch) {
            this.notImplemented(channel, RestRequest.Method.PATCH);
        } else {
            super.handleApiRequest(channel, request, client, content);
        }
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        if (this.allowPutOrPatch) {
            request.param("name");
            super.handlePut("sg_config", channel, request, client, content);
        } else {
            this.notImplemented(channel, RestRequest.Method.PUT);
        }
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.DELETE);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new SgConfigValidator(request, ref, this.settings, param);
    }

    protected CType<LegacySgConfig> getConfigName() {
        return CType.CONFIG;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.SGCONFIG;
    }

    @Override
    protected String getResourceName() {
        return null;
    }
}

