/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.Collection;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Validator {
    private Validator() {
    }

    public static void ensureNotNull(@Nullable Object o) throws LDAPSDKUsageException {
        if (o == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(0, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullWithMessage(@Nullable Object o, @NotNull String message) throws LDAPSDKUsageException {
        if (o == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(@Nullable Object o1, @Nullable Object o2) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null) {
            int index = o1 == null ? 0 : 1;
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(@Nullable Object o1, @Nullable Object o2, @Nullable Object o3) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : 2);
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(@Nullable Object o1, @Nullable Object o2, @Nullable Object o3, @Nullable Object o4) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null || o4 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : (o3 == null ? 2 : 3));
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(@Nullable Object o1, @Nullable Object o2, @Nullable Object o3, @Nullable Object o4, @Nullable Object o5) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null || o4 == null || o5 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : (o3 == null ? 2 : (o4 == null ? 3 : 4)));
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_COLLECTION_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (collection.isEmpty()) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_COLLECTION_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Collection<?> collection, @NotNull String message) {
        if (collection == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_COLLECTION_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (collection.isEmpty()) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_COLLECTION_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Map<?, ?> map) {
        if (map == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_MAP_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (map.isEmpty()) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_MAP_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Map<?, ?> map, @NotNull String message) {
        if (map == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_MAP_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (map.isEmpty()) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_MAP_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Object[] array) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable Object[] array, @NotNull String message) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable byte[] array) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable byte[] array, @NotNull String message) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable char[] array) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable char[] array, @NotNull String message) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable int[] array) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable int[] array, @NotNull String message) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable long[] array) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable long[] array, @NotNull String message) {
        if (array == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (array.length == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_ARRAY_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_CHAR_SEQUENCE_NULL.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (charSequence.length() == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_CHAR_SEQUENCE_EMPTY.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullOrEmpty(@Nullable CharSequence charSequence, @NotNull String message) {
        if (charSequence == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_CHAR_SEQUENCE_NULL_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
        if (charSequence.length() == 0) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_CHAR_SEQUENCE_EMPTY_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureTrue(boolean condition) throws LDAPSDKUsageException {
        if (!condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_TRUE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureTrue(boolean condition, @NotNull String message) throws LDAPSDKUsageException {
        if (!condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureFalse(boolean condition) throws LDAPSDKUsageException {
        if (condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FALSE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureFalse(boolean condition, @NotNull String message) throws LDAPSDKUsageException {
        if (condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void violation(@NotNull String message) throws LDAPSDKUsageException {
        Validator.violation(message, null);
    }

    public static void violation(@NotNull String message, @Nullable Throwable cause) throws LDAPSDKUsageException {
        LDAPSDKUsageException e = new LDAPSDKUsageException(message, cause);
        Debug.debugCodingError(e);
        throw e;
    }
}

