/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.support.IPAddressCollection;
import inet.ipaddr.IPAddress;

public class IPAddressAcceptanceRules {
    public static final IPAddressAcceptanceRules ANY = new IPAddressAcceptanceRules(null, null);
    private final Criteria accept;
    private final Criteria skip;

    public IPAddressAcceptanceRules(Criteria accept, Criteria skip) {
        this.accept = accept;
        this.skip = skip;
    }

    public boolean accept(RequestMetaData<?> requestMetaData) {
        IPAddress directIpAddress = requestMetaData.getDirectIpAddress();
        if (this.accept != null && this.accept.directIps != null && !this.accept.directIps.contains(directIpAddress)) {
            return false;
        }
        if (this.skip != null && this.skip.directIps != null && this.skip.directIps.contains(directIpAddress)) {
            return false;
        }
        IPAddress originatingIpAddress = requestMetaData.getOriginatingIpAddress();
        if (this.accept != null && this.accept.originatingIps != null && !this.accept.originatingIps.contains(originatingIpAddress)) {
            return false;
        }
        if (this.skip != null && this.skip.originatingIps != null && this.skip.originatingIps.contains(originatingIpAddress)) {
            return false;
        }
        return this.accept == null || !this.accept.trustedIps || requestMetaData.isTrustedProxy();
    }

    public static class Criteria {
        private final IPAddressCollection originatingIps;
        private final IPAddressCollection directIps;
        private final boolean trustedIps;

        public Criteria(IPAddressCollection originatingIps, IPAddressCollection directIps, boolean trustedIps) {
            this.originatingIps = originatingIps;
            this.directIps = directIps;
            this.trustedIps = trustedIps;
        }

        public static Criteria parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            IPAddressCollection originatingIps = (IPAddressCollection)vNode.get("originating_ips").by(IPAddressCollection::parse);
            IPAddressCollection directIps = (IPAddressCollection)vNode.get("ips").by(IPAddressCollection::parse);
            boolean trustedIps = vNode.get("trusted_ips").withDefault(false).asBoolean();
            validationErrors.throwExceptionForPresentErrors();
            return new Criteria(originatingIps, directIps, trustedIps);
        }

        public IPAddressCollection getOriginatingIps() {
            return this.originatingIps;
        }

        public IPAddressCollection getDirectIps() {
            return this.directIps;
        }

        public boolean isTrustedIps() {
            return this.trustedIps;
        }
    }
}

