/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.KeyProvider;
import com.google.common.base.Strings;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public class JwtVerifier {
    private final KeyProvider keyProvider;
    private final String requiredAudience;
    private final String requiredIssuer;
    private final int maxClockSkewSeconds;

    public JwtVerifier(KeyProvider keyProvider, String requiredAudience, String requiredIssuer, int maxClockSkewSeconds) {
        this.keyProvider = keyProvider;
        this.requiredAudience = requiredAudience;
        this.requiredIssuer = requiredIssuer;
        this.maxClockSkewSeconds = maxClockSkewSeconds;
    }

    public JwtToken getVerifiedJwtToken(String encodedJwt) throws BadCredentialsException, AuthenticatorUnavailableException {
        try {
            JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(encodedJwt);
            JwtToken jwt = jwtConsumer.getJwtToken();
            this.validateIssuer(jwt);
            this.validateAudienceRestriction(jwt);
            JsonWebKey key = this.keyProvider.getKey(jwt.getJwsHeaders().getKeyId());
            JwsSignatureVerifier signatureVerifier = this.getInitializedSignatureVerifier(key, jwt);
            boolean signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier);
            if (!signatureValid && Strings.isNullOrEmpty((String)jwt.getJwsHeaders().getKeyId())) {
                key = this.keyProvider.getKeyAfterRefresh(null);
                signatureVerifier = this.getInitializedSignatureVerifier(key, jwt);
                signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier);
            }
            if (!signatureValid) {
                throw new BadCredentialsException("Invalid JWT signature");
            }
            this.validateClaims(jwt);
            return jwt;
        }
        catch (JwtException e) {
            throw new BadCredentialsException(e.getMessage(), e);
        }
    }

    private void validateSignatureAlgorithm(JsonWebKey key, JwtToken jwt) throws BadCredentialsException {
        SignatureAlgorithm tokenAlgorithm;
        if (Strings.isNullOrEmpty((String)key.getAlgorithm())) {
            return;
        }
        SignatureAlgorithm keyAlgorithm = SignatureAlgorithm.getAlgorithm((String)key.getAlgorithm());
        if (!keyAlgorithm.equals((Object)(tokenAlgorithm = SignatureAlgorithm.getAlgorithm((String)jwt.getJwsHeaders().getAlgorithm())))) {
            throw new BadCredentialsException("Algorithm of JWT does not match algorithm of JWK (" + String.valueOf(keyAlgorithm) + " != " + String.valueOf(tokenAlgorithm) + ")");
        }
    }

    private JwsSignatureVerifier getInitializedSignatureVerifier(JsonWebKey key, JwtToken jwt) throws BadCredentialsException, JwtException {
        this.validateSignatureAlgorithm(key, jwt);
        JwsSignatureVerifier result = JwsUtils.getSignatureVerifier((JsonWebKey)key, (SignatureAlgorithm)jwt.getJwsHeaders().getSignatureAlgorithm());
        if (result == null) {
            throw new BadCredentialsException("Cannot verify JWT");
        }
        return result;
    }

    private void validateClaims(JwtToken jwt) throws JwtException {
        JwtClaims claims = jwt.getClaims();
        if (claims != null) {
            JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)0, (boolean)false);
            try {
                JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)this.maxClockSkewSeconds, (boolean)false);
            }
            catch (JwtException jwtException) {
                String notBefore = DateTimeFormatter.ISO_DATE_TIME.format(Instant.ofEpochSecond(claims.getNotBefore()).atZone(ZoneId.systemDefault()));
                throw new JwtException(jwtException.getMessage() + ", not before claim is set to: " + notBefore + ", max clock skew is " + this.maxClockSkewSeconds + " seconds");
            }
        }
    }

    private void validateAudienceRestriction(JwtToken jwt) {
        if (this.requiredAudience == null) {
            return;
        }
        JwtClaims claims = jwt.getClaims();
        if (claims == null) {
            throw new JwtException("No claims defined");
        }
        if (!claims.getAudiences().contains(this.requiredAudience)) {
            throw new JwtException("Invalid audience claim: " + String.valueOf(claims.getAudiences()));
        }
    }

    private void validateIssuer(JwtToken jwt) {
        if (this.requiredIssuer == null) {
            return;
        }
        JwtClaims claims = jwt.getClaims();
        if (claims == null) {
            throw new JwtException("No claims defined");
        }
        if (!this.requiredIssuer.equals(claims.getIssuer())) {
            throw new JwtException("Invalid issuer claim: " + claims.getIssuer());
        }
    }
}

