/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.UpdateMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class UpdateRequestHandler
extends RequestHandler<UpdateRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final UpdateMapper updateMapper;

    public UpdateRequestHandler(Client nodeClient, ThreadContext threadContext) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.updateMapper = new UpdateMapper();
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, UpdateRequest request, ActionListener<?> listener) {
        this.log.debug("Handle update request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            UpdateRequest scoped = this.updateMapper.toScopedUpdateRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<UpdateResponse> listenerWrapper = new TenantScopedActionListenerWrapper<UpdateResponse>(listener, storedContext, this.updateMapper);
            this.nodeClient.update(scoped, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

