/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.SecureRandomProvider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public final class CryptoServicesRegistrar {
    private static final Logger LOG = Logger.getLogger(CryptoServicesRegistrar.class.getName());
    private static final ThreadLocal<Map<String, Object[]>> threadProperties = new ThreadLocal();
    private static final Map<String, Object[]> globalProperties = Collections.synchronizedMap(new HashMap());
    private static final SecureRandomProvider defaultRandomProviderImpl = new ThreadLocalSecureRandomProvider();
    private static final AtomicReference<SecureRandomProvider> defaultSecureRandomProvider = new AtomicReference();

    private CryptoServicesRegistrar() {
    }

    public static SecureRandom getSecureRandom() {
        defaultSecureRandomProvider.compareAndSet(null, defaultRandomProviderImpl);
        return defaultSecureRandomProvider.get().get();
    }

    public static SecureRandom getSecureRandom(SecureRandom secureRandom) {
        return null == secureRandom ? CryptoServicesRegistrar.getSecureRandom() : secureRandom;
    }

    public static void setSecureRandom(final SecureRandom secureRandom) {
        if (secureRandom == null) {
            defaultSecureRandomProvider.set(defaultRandomProviderImpl);
        } else {
            defaultSecureRandomProvider.set(new SecureRandomProvider(){

                @Override
                public SecureRandom get() {
                    return secureRandom;
                }
            });
        }
    }

    public static void setSecureRandomProvider(SecureRandomProvider secureRandomProvider) {
        defaultSecureRandomProvider.set(secureRandomProvider);
    }

    private static int chooseLowerBound(int pSize) {
        int m = 160;
        if (pSize > 1024) {
            m = pSize <= 2048 ? 224 : (pSize <= 3072 ? 256 : (pSize <= 7680 ? 384 : 512));
        }
        return m;
    }

    private static class ThreadLocalSecureRandomProvider
    implements SecureRandomProvider {
        final ThreadLocal<SecureRandom> defaultRandoms = new ThreadLocal();

        private ThreadLocalSecureRandomProvider() {
        }

        @Override
        public SecureRandom get() {
            if (this.defaultRandoms.get() == null) {
                this.defaultRandoms.set(new SecureRandom());
            }
            return this.defaultRandoms.get();
        }
    }
}

