/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.actions;

import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateRequest;
import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateResponse;
import com.floragunn.searchsupport.jobs.core.IndexJobStateStore;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportSchedulerConfigUpdateAction
extends TransportNodesAction<SchedulerConfigUpdateRequest, SchedulerConfigUpdateResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportSchedulerConfigUpdateAction.class);

    @Inject
    public TransportSchedulerConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/searchsupport/scheduler/config/update", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
    }

    protected SchedulerConfigUpdateResponse newResponse(SchedulerConfigUpdateRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new SchedulerConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        try {
            IndexJobStateStore<?> jobStore = IndexJobStateStore.getInstanceBySchedulerName(localNode.getId(), request.schedulerName);
            if (jobStore == null) {
                log.warn("A job store for scheduler name " + request.schedulerName + " does not exist (" + localNode.getId() + ")");
                return new NodeResponse(localNode, NodeResponse.Status.NO_SUCH_JOB_STORE, "A job store for scheduler name " + request.schedulerName + " does not exist");
            }
            String nodeId = jobStore.getNodeId();
            if (nodeId != null && !localNode.getId().equals(nodeId)) {
                log.error("The scheduler with the name " + request.schedulerName + " is not configured for this node: " + localNode.getId() + " vs " + jobStore.getNodeId());
                return new NodeResponse(localNode, NodeResponse.Status.NO_SUCH_JOB_STORE, "The scheduler with the name " + request.schedulerName + " is not configured for this node: " + localNode.getId() + " vs " + jobStore.getNodeId());
            }
            String status = jobStore.updateJobs();
            return new NodeResponse(localNode, NodeResponse.Status.SUCCESS, status);
        }
        catch (Exception e) {
            log.error("Error while updating jobs", (Throwable)e);
            return new NodeResponse(localNode, NodeResponse.Status.EXCEPTION, e.toString());
        }
    }

    protected NodeRequest newNodeRequest(SchedulerConfigUpdateRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        private String schedulerName;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.schedulerName = in.readString();
        }

        public NodeRequest(SchedulerConfigUpdateRequest request) {
            this.schedulerName = request.getSchedulerName();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.schedulerName);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private Status status;
        private String message;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.status = (Status)in.readEnum(Status.class);
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node, Status status, String message) {
            super(node);
            this.status = status;
            this.message = message;
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public Status getStatus() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.message);
        }

        public String toString() {
            return "NodeResponse [status=" + String.valueOf((Object)this.status) + ", message=" + this.message + "]";
        }

        public static enum Status {
            SUCCESS,
            NO_SUCH_JOB_STORE,
            EXCEPTION;

        }
    }
}

