/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.SystemIndexAccess;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchsupport.action.IndicesOptionsSupport;
import com.floragunn.searchsupport.meta.Meta;
import com.floragunn.searchsupport.queries.DateMathExpressionResolver;
import com.floragunn.searchsupport.queries.WildcardExpressionResolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;

public class ResolvedIndices {
    static final ResolvedIndices EMPTY = new ResolvedIndices(false, Local.EMPTY, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo>)ImmutableSet.empty());
    private static final Logger log = LogManager.getLogger(ResolvedIndices.class);
    private final boolean localAll;
    private ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo> deferredRequests;
    private Local localShallow;
    protected final ImmutableSet<String> remoteIndices;

    ResolvedIndices(boolean localAll, Local localShallow, ImmutableSet<String> remoteIndices, ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo> deferredRequests) {
        this.localAll = localAll;
        this.localShallow = localShallow;
        this.remoteIndices = remoteIndices;
        this.deferredRequests = deferredRequests;
    }

    public boolean isLocalAll() {
        return this.localAll;
    }

    public boolean isLocalIndicesEmpty() {
        return !this.localAll && this.getLocal().isEmpty();
    }

    public boolean containsOnlyRemoteIndices() {
        return !this.localAll && this.deferredRequests.isEmpty() && this.localShallow.isEmpty() && !this.remoteIndices.isEmpty();
    }

    ResolvedIndices with(ResolvedIndices other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        return new ResolvedIndices(this.localAll || other.localAll, this.localShallow.with(other.localShallow), (ImmutableSet<String>)this.remoteIndices.with(other.remoteIndices), (ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo>)this.deferredRequests.with(other.deferredRequests));
    }

    ResolvedIndices with(Collection<ResolvedIndices> others) {
        if (others == null || others.isEmpty()) {
            return this;
        }
        ResolvedIndices result = this;
        for (ResolvedIndices other : others) {
            result = result.with(other);
        }
        return result;
    }

    private void resolveDeferredRequests() {
        Local localShallow = this.localShallow;
        for (ActionRequestIntrospector.IndicesRequestInfo info : this.deferredRequests) {
            localShallow = localShallow.with(Local.resolve(info, info.indexMetadata));
        }
        this.deferredRequests = ImmutableSet.empty();
        this.localShallow = localShallow;
    }

    public Local getLocal() {
        if (!this.deferredRequests.isEmpty()) {
            this.resolveDeferredRequests();
        }
        return this.localShallow;
    }

    public ImmutableSet<String> getRemoteIndices() {
        return this.remoteIndices;
    }

    public ImmutableSet<String> getLocalAndRemoteIndices() {
        return this.getLocal().getUnion().map(Meta.IndexLikeObject::name).with(this.getRemoteIndices());
    }

    public ImmutableSet<String> getLocalSubset(Set<String> superSet) {
        return this.getLocal().getUnion().map(Meta.IndexLikeObject::name).intersection(superSet).with(this.remoteIndices);
    }

    public String[] getLocalSubsetAsArray(Set<String> superSet) {
        ImmutableSet<String> result = this.getLocalSubset(superSet);
        return (String[])result.toArray((Object[])new String[result.size()]);
    }

    public String toString() {
        if (this.localAll) {
            if (this.remoteIndices.isEmpty() && !this.deferredRequests.isEmpty()) {
                return "local: _all";
            }
            StringBuilder result = new StringBuilder("local: _all");
            if (this.deferredRequests.isEmpty()) {
                result.append(" [").append(this.localShallow.size()).append("]");
            }
            if (!this.remoteIndices.isEmpty()) {
                result.append("; remote: ").append(this.remoteIndices.toShortString());
            }
            return result.toString();
        }
        return "local: " + String.valueOf(this.localShallow != null ? this.localShallow : "null") + "; remote: " + (this.remoteIndices != null ? this.remoteIndices.toShortString() : "null");
    }

    public static ResolvedIndices of(Meta indexMetadata, String ... indices) {
        return new ResolvedIndices(false, Local.resolve(indexMetadata, indices), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo>)ImmutableSet.empty());
    }

    public ResolvedIndices local(Local local) {
        return new ResolvedIndices(false, local, this.remoteIndices, (ImmutableSet<ActionRequestIntrospector.IndicesRequestInfo>)ImmutableSet.empty());
    }

    public static ResolvedIndices empty() {
        return EMPTY;
    }

    public static class Local {
        private final ImmutableSet<Meta.Index> pureIndices;
        private final ImmutableSet<Meta.Alias> aliases;
        private final ImmutableSet<Meta.DataStream> dataStreams;
        private final ImmutableSet<Meta.NonExistent> nonExistingIndices;
        private final ImmutableSet<String> unionOfAliasesAndDataStreams;
        private final ImmutableSet<Meta.IndexLikeObject> union;
        private String asString;
        private ImmutableSet<String> deepUnion;
        private Boolean containsAliasOrDataStreamMembers;
        static final Local EMPTY = new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());

        Local(ImmutableSet<Meta.Index> pureIndices, ImmutableSet<Meta.Alias> aliases, ImmutableSet<Meta.DataStream> dataStreams, ImmutableSet<Meta.NonExistent> nonExistingIndices) {
            this.pureIndices = pureIndices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
            this.nonExistingIndices = nonExistingIndices;
            this.unionOfAliasesAndDataStreams = aliases.map(Meta.IndexLikeObject::name).with((Collection)dataStreams.map(Meta.IndexLikeObject::name));
            this.union = ImmutableSet.of(pureIndices).with(aliases).with(dataStreams).with(this.nonExistingIndices);
        }

        private Local(ImmutableSet<Meta.Index> pureIndices, ImmutableSet<Meta.Alias> aliases, ImmutableSet<Meta.DataStream> dataStreams, ImmutableSet<Meta.NonExistent> nonExistingIndices, ImmutableSet<String> unionOfAliasesAndDataStreams, ImmutableSet<Meta.IndexLikeObject> union) {
            this.pureIndices = pureIndices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
            this.nonExistingIndices = nonExistingIndices;
            this.unionOfAliasesAndDataStreams = unionOfAliasesAndDataStreams;
            this.union = union;
        }

        boolean isEmpty() {
            return this.union.isEmpty();
        }

        Local with(Local other) {
            if (this.union.equals(other.union)) {
                return this;
            }
            if (this.unionOfAliasesAndDataStreams.equals(other.unionOfAliasesAndDataStreams)) {
                return new Local((ImmutableSet<Meta.Index>)this.pureIndices.with(other.pureIndices), this.aliases, this.dataStreams, (ImmutableSet<Meta.NonExistent>)this.nonExistingIndices.with(other.nonExistingIndices), this.unionOfAliasesAndDataStreams, (ImmutableSet<Meta.IndexLikeObject>)this.union.with(other.union));
            }
            ImmutableSet.Builder mergedPureIndices = new ImmutableSet.Builder(this.pureIndices.size() + other.pureIndices.size());
            for (Meta.Index index : this.pureIndices) {
                if (index.parentDataStreamName() != null && other.dataStreams.contains((Object)index.parentDataStream()) || other.aliases.containsAny((Collection)index.parentAliases())) continue;
                mergedPureIndices.add((Object)index);
            }
            for (Meta.Index index : other.pureIndices) {
                if (index.parentDataStreamName() != null && this.dataStreams.contains((Object)index.parentDataStream()) || this.aliases.containsAny((Collection)index.parentAliases())) continue;
                mergedPureIndices.add((Object)index);
            }
            return new Local((ImmutableSet<Meta.Index>)mergedPureIndices.build(), (ImmutableSet<Meta.Alias>)this.aliases.with(other.aliases), (ImmutableSet<Meta.DataStream>)this.dataStreams.with(other.dataStreams), (ImmutableSet<Meta.NonExistent>)this.nonExistingIndices.with(other.nonExistingIndices));
        }

        public int size() {
            return this.union.size();
        }

        public ImmutableSet<Meta.Index> getPureIndices() {
            return this.pureIndices;
        }

        public ImmutableSet<Meta.Alias> getAliases() {
            return this.aliases;
        }

        public ImmutableSet<Meta.DataStream> getDataStreams() {
            return this.dataStreams;
        }

        public ImmutableSet<Meta.IndexCollection> getAliasesAndDataStreams() {
            return ImmutableSet.of(this.aliases).with(this.dataStreams);
        }

        public ImmutableSet<Meta.NonExistent> getNonExistingIndices() {
            return this.nonExistingIndices;
        }

        public ImmutableSet<Meta.IndexLikeObject> getUnion() {
            return this.union;
        }

        public ImmutableSet<String> getDeepUnion() {
            ImmutableSet result = this.deepUnion;
            if (result == null) {
                this.deepUnion = result = Meta.IndexLikeObject.resolveDeepToNames(this.aliases, (Meta.Alias.ResolutionMode)Meta.Alias.ResolutionMode.NORMAL).with((Collection)Meta.IndexLikeObject.resolveDeepToNames(this.dataStreams, (Meta.Alias.ResolutionMode)Meta.Alias.ResolutionMode.NORMAL)).with((Collection)this.union.map(Meta.IndexLikeObject::name));
            }
            return result;
        }

        public boolean hasAliasOrDataStreamMembers() {
            Boolean result = this.containsAliasOrDataStreamMembers;
            if (result == null) {
                for (Meta.Index pureIndex : this.pureIndices) {
                    if (pureIndex.parentAliasNames().isEmpty() && pureIndex.parentDataStreamName() == null) continue;
                    result = true;
                    break;
                }
                for (Meta.DataStream dataStream : this.dataStreams) {
                    if (dataStream.parentAliasNames().isEmpty()) continue;
                    result = true;
                    break;
                }
                if (result == null) {
                    result = false;
                }
                this.containsAliasOrDataStreamMembers = result;
            }
            return result;
        }

        boolean hasAliasesOrDataStreams() {
            return !this.aliases.isEmpty() || !this.dataStreams.isEmpty();
        }

        public boolean hasAliasesOnly() {
            return !this.aliases.isEmpty() && this.dataStreams.isEmpty() && this.pureIndices.isEmpty();
        }

        public boolean hasNonExistingObjects() {
            return !this.nonExistingIndices.isEmpty() || this.pureIndices.forAnyApplies(i -> !i.exists()) || this.aliases.forAnyApplies(a -> !a.exists()) || this.dataStreams.forAnyApplies(d -> !d.exists());
        }

        public String toString() {
            String result = this.asString;
            if (result != null) {
                return result;
            }
            StringBuilder resultBuilder = new StringBuilder("{");
            if (!this.pureIndices.isEmpty()) {
                resultBuilder.append("indices: ").append(this.pureIndices);
            }
            if (!this.aliases.isEmpty()) {
                if (!this.pureIndices.isEmpty()) {
                    resultBuilder.append("; ");
                }
                resultBuilder.append("aliases: ").append(this.aliases);
            }
            if (!this.dataStreams.isEmpty()) {
                if (!this.pureIndices.isEmpty() || !this.aliases.isEmpty()) {
                    resultBuilder.append("; ");
                }
                resultBuilder.append("dataStreams: ").append(this.dataStreams);
            }
            if (!this.nonExistingIndices.isEmpty()) {
                if (!(this.pureIndices.isEmpty() && this.aliases.isEmpty() && this.dataStreams.isEmpty())) {
                    resultBuilder.append("; ");
                }
                resultBuilder.append("nonExistingIndices: ").append(this.nonExistingIndices);
            }
            resultBuilder.append("}");
            this.asString = result = resultBuilder.toString();
            return result;
        }

        static Local resolve(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            try {
                if (request.scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.DATA_STREAM) {
                    if (request.isAll) {
                        return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)(request.indicesOptions().expandWildcardsHidden() ? indexMetadata.dataStreams() : indexMetadata.nonHiddenDataStreams()), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
                    }
                    if (request.expandWildcards) {
                        return Local.resolveWithPatterns(request, indexMetadata);
                    }
                    if (request.createIndexRequest) {
                        return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)ImmutableSet.of((Collection)Local.resolveDateMathExpressions(request.localIndices).map(Meta.DataStream::nonExistent)), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
                    }
                    return Local.resolveDataStreamsWithoutPatterns(request, indexMetadata);
                }
                if (request.scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS) {
                    if (request.isAll) {
                        return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)indexMetadata.aliases(), (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
                    }
                    if (request.expandWildcards) {
                        return Local.resolveWithPatterns(request, indexMetadata);
                    }
                    if (request.createIndexRequest) {
                        return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)ImmutableSet.of((Collection)Local.resolveDateMathExpressions(request.localIndices).map(Meta.Alias::nonExistent)), (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
                    }
                    return Local.resolveAliasesWithoutPatterns(request, indexMetadata);
                }
                if (request.isAll) {
                    return Local.resolveIsAll(request, indexMetadata);
                }
                if (request.expandWildcards) {
                    return Local.resolveWithPatterns(request, indexMetadata);
                }
                return Local.resolveWithoutPatterns(request, indexMetadata);
            }
            catch (RuntimeException e) {
                log.error("Error while resolving " + String.valueOf(request), (Throwable)e);
                throw e;
            }
        }

        public static Local resolve(Meta indexMetadata, String ... indices) {
            return Local.resolveWithoutPatterns(new ActionRequestIntrospector.IndicesRequestInfo(null, (List<String>)ImmutableList.ofArray((Object[])indices), IndicesOptionsSupport.EXACT, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, SystemIndexAccess.DISALLOWED, indexMetadata), indexMetadata);
        }

        static Local resolveWithPatterns(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            Metadata metadata = indexMetadata.esMetadata();
            ActionRequestIntrospector.IndicesRequestInfo.Scope scope = request.scope;
            boolean includeDataStreams = request.includeDataStreams && scope.includeDataStreams;
            boolean includeIndices = scope.includeIndices;
            boolean includeAliases = scope.includeAliases && !request.indicesOptions().ignoreAliases() || scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS;
            SortedMap indicesLookup = metadata.getProject().getIndicesLookup();
            ImmutableSet.Builder indices = new ImmutableSet.Builder();
            ImmutableSet.Builder nonExistingIndices = new ImmutableSet.Builder();
            ImmutableSet.Builder aliases = new ImmutableSet.Builder();
            ImmutableSet.Builder dataStreams = new ImmutableSet.Builder();
            HashSet<String> excludeNames = new HashSet<String>();
            HashSet<String> partiallyExcludedObjects = new HashSet<String>();
            for (int i = request.localIndices.size() - 1; i >= 0; --i) {
                Meta.Index indexMeta;
                Map matchedAbstractions;
                String index2 = (String)request.localIndices.get(i);
                if (index2.startsWith("-")) {
                    index2 = index2.substring(1);
                    if ((index2 = DateMathExpressionResolver.resolveExpression((String)index2)).contains("*")) {
                        matchedAbstractions = WildcardExpressionResolver.matches((Metadata)metadata, (SortedMap)indicesLookup, (String)index2, (IndicesOptions)request.indicesOptions(), (boolean)includeDataStreams);
                        for (String resolvedIndex : matchedAbstractions.keySet()) {
                            Local.resolveNegationUpAndDown(resolvedIndex, excludeNames, partiallyExcludedObjects, request, indexMetadata);
                        }
                        continue;
                    }
                    Local.resolveNegationUpAndDown(index2, excludeNames, partiallyExcludedObjects, request, indexMetadata);
                    continue;
                }
                if ((index2 = DateMathExpressionResolver.resolveExpression((String)index2)).contains("*")) {
                    matchedAbstractions = WildcardExpressionResolver.matches((Metadata)metadata, (SortedMap)indicesLookup, (String)index2, (IndicesOptions)request.indicesOptions(), (boolean)includeDataStreams);
                    for (Map.Entry entry : matchedAbstractions.entrySet()) {
                        if (excludeNames.contains(entry.getKey())) continue;
                        if (!partiallyExcludedObjects.contains(entry.getKey()) || scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS || scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.DATA_STREAM || scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.INDICES_DATA_STREAMS) {
                            Meta.Index indexMeta2;
                            IndexAbstraction indexAbstraction = (IndexAbstraction)entry.getValue();
                            if (indexAbstraction instanceof DataStream) {
                                if (!includeDataStreams) continue;
                                dataStreams.add((Object)((Meta.DataStream)indexMetadata.getIndexOrLike((String)entry.getKey())));
                                continue;
                            }
                            if (indexAbstraction instanceof IndexAbstraction.Alias) {
                                if (!includeAliases) continue;
                                aliases.add((Object)((Meta.Alias)indexMetadata.getIndexOrLike((String)entry.getKey())));
                                continue;
                            }
                            if (!includeIndices || (indexMeta2 = (Meta.Index)indexMetadata.getIndexOrLike((String)entry.getKey())).isSystem() && !request.systemIndexAccess.isAllowed((String)entry.getKey())) continue;
                            indices.add((Object)indexMeta2);
                            continue;
                        }
                        Meta.IndexLikeObject indexLike = indexMetadata.getIndexOrLike((String)entry.getKey());
                        if (indexLike instanceof Meta.IndexCollection) {
                            for (Meta.IndexLikeObject member : ((Meta.IndexCollection)indexLike).members()) {
                                if (excludeNames.contains(member.name())) continue;
                                if (member instanceof Meta.Index) {
                                    Meta.Index indexMeta3;
                                    if (!includeIndices || (indexMeta3 = (Meta.Index)member).isSystem() && !request.systemIndexAccess.isAllowed((String)entry.getKey())) continue;
                                    indices.add((Object)indexMeta3);
                                    continue;
                                }
                                if (!(member instanceof Meta.DataStream) || !includeDataStreams) continue;
                                Meta.DataStream dataStream = (Meta.DataStream)member;
                                if (dataStream.members().stream().anyMatch(dsMember -> excludeNames.contains(dsMember.name()))) {
                                    for (Meta.IndexLikeObject dsMember2 : dataStream.members()) {
                                        if (excludeNames.contains(dsMember2.name())) continue;
                                        indices.add((Object)((Meta.Index)dsMember2));
                                    }
                                    continue;
                                }
                                dataStreams.add((Object)dataStream);
                            }
                            continue;
                        }
                        indices.add((Object)((Meta.Index)indexLike));
                    }
                    continue;
                }
                if (excludeNames.contains(index2)) continue;
                Meta.IndexLikeObject indexLikeObject = indexMetadata.getIndexOrLike(index2);
                if (indexLikeObject == null) {
                    if (scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.DATA_STREAM) {
                        dataStreams.add((Object)Meta.DataStream.nonExistent((String)index2));
                        continue;
                    }
                    if (scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS) {
                        aliases.add((Object)Meta.Alias.nonExistent((String)index2));
                        continue;
                    }
                    nonExistingIndices.add((Object)Meta.NonExistent.of((String)index2));
                    continue;
                }
                if (indexLikeObject instanceof Meta.Alias) {
                    if (!includeAliases) continue;
                    aliases.add((Object)((Meta.Alias)indexLikeObject));
                    continue;
                }
                if (indexLikeObject instanceof Meta.DataStream) {
                    if (!includeDataStreams) continue;
                    dataStreams.add((Object)((Meta.DataStream)indexLikeObject));
                    continue;
                }
                if (!includeIndices || (indexMeta = (Meta.Index)indexLikeObject).isSystem() && !request.systemIndexAccess.isAllowed((Meta.IndexLikeObject)indexMeta)) continue;
                indices.add((Object)((Meta.Index)indexLikeObject));
            }
            ImmutableSet pureIndices = indices.build();
            if ((aliases.size() != 0 || dataStreams.size() != 0) && scope != ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY_DISTINCT) {
                pureIndices = pureIndices.matching(index -> {
                    if (index.parentDataStreamName() != null && dataStreams.contains((Object)index.parentDataStream())) {
                        return false;
                    }
                    return !aliases.containsAny((Set)index.parentAliases());
                });
            }
            return new Local((ImmutableSet<Meta.Index>)pureIndices, (ImmutableSet<Meta.Alias>)aliases.build(), (ImmutableSet<Meta.DataStream>)dataStreams.build(), (ImmutableSet<Meta.NonExistent>)nonExistingIndices.build());
        }

        static Local resolveIsAll(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            ImmutableSet dataStreams;
            ImmutableSet aliases;
            ImmutableSet pureIndices;
            ActionRequestIntrospector.IndicesRequestInfo.Scope scope = request.scope;
            boolean includeHidden = request.indicesOptions().expandWildcardsHidden();
            boolean excludeSystem = request.systemIndexAccess.isNotAllowed();
            boolean includeDataStreams = request.includeDataStreams && scope.includeDataStreams;
            boolean includeIndices = scope.includeIndices;
            boolean includeAliases = scope.includeAliases && !request.indicesOptions().ignoreAliases() || scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS;
            ImmutableSet nonExistingIndices = ImmutableSet.empty();
            if (includeDataStreams && includeAliases && scope != ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY_DISTINCT) {
                pureIndices = !includeIndices ? ImmutableSet.empty() : (!includeHidden ? indexMetadata.nonHiddenIndicesWithoutParents() : (excludeSystem ? indexMetadata.nonSystemIndicesWithoutParents() : indexMetadata.indicesWithoutParents()));
                aliases = includeHidden ? indexMetadata.aliases() : indexMetadata.nonHiddenAliases();
                dataStreams = includeHidden ? indexMetadata.dataStreams() : indexMetadata.nonHiddenDataStreams();
            } else {
                pureIndices = !includeIndices ? ImmutableSet.empty() : (!includeHidden ? indexMetadata.nonHiddenIndices() : (excludeSystem ? indexMetadata.nonSystemIndices() : indexMetadata.indices()));
                ImmutableSet immutableSet = includeAliases ? (includeHidden ? indexMetadata.aliases() : indexMetadata.nonHiddenAliases()) : (aliases = ImmutableSet.empty());
                ImmutableSet immutableSet2 = includeDataStreams ? (includeHidden ? indexMetadata.dataStreams() : indexMetadata.nonHiddenDataStreams()) : (dataStreams = ImmutableSet.empty());
                if (scope != ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY_DISTINCT) {
                    if (!dataStreams.isEmpty()) {
                        pureIndices = pureIndices.matching(e -> e.parentDataStreamName() == null);
                    }
                    if (!aliases.isEmpty()) {
                        pureIndices = pureIndices.matching(e -> e.parentAliasNames().isEmpty());
                    }
                }
            }
            Predicate excludeStatePredicate = WildcardExpressionResolver.excludeStatePredicate((IndicesOptions)request.indicesOptions());
            if (excludeStatePredicate != null) {
                pureIndices = pureIndices.matching(e -> !excludeStatePredicate.test(e.isOpen()));
            }
            pureIndices = pureIndices.matching(index -> !index.isSystem() || request.systemIndexAccess.isAllowed((Meta.IndexLikeObject)index));
            return new Local((ImmutableSet<Meta.Index>)pureIndices, (ImmutableSet<Meta.Alias>)aliases, (ImmutableSet<Meta.DataStream>)dataStreams, (ImmutableSet<Meta.NonExistent>)nonExistingIndices);
        }

        static Local resolveWithoutPatterns(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            ActionRequestIntrospector.IndicesRequestInfo.Scope scope = request.scope;
            ImmutableSet.Builder indices = new ImmutableSet.Builder();
            ImmutableSet.Builder nonExistingIndices = new ImmutableSet.Builder();
            ImmutableSet.Builder aliases = new ImmutableSet.Builder();
            ImmutableSet.Builder dataStreams = new ImmutableSet.Builder();
            for (String index2 : request.localIndices) {
                String resolved = DateMathExpressionResolver.resolveExpression((String)index2);
                if (ActionRequestIntrospector.containsWildcard(resolved)) continue;
                Meta.IndexLikeObject indexLike = indexMetadata.getIndexOrLike(resolved);
                if (scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.INDEX) {
                    if (indexLike instanceof Meta.Index) {
                        indices.add((Object)((Meta.Index)indexLike));
                        continue;
                    }
                    indices.add((Object)Meta.Index.nonExistent((String)resolved));
                    continue;
                }
                if (scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.ALIAS) {
                    if (indexLike instanceof Meta.Alias) {
                        aliases.add((Object)((Meta.Alias)indexLike));
                        continue;
                    }
                    aliases.add((Object)Meta.Alias.nonExistent((String)resolved));
                    continue;
                }
                if (scope == ActionRequestIntrospector.IndicesRequestInfo.Scope.DATA_STREAM) {
                    if (indexLike instanceof Meta.DataStream) {
                        dataStreams.add((Object)((Meta.DataStream)indexLike));
                        continue;
                    }
                    dataStreams.add((Object)Meta.DataStream.nonExistent((String)resolved));
                    continue;
                }
                if (indexLike == null) {
                    nonExistingIndices.add((Object)Meta.NonExistent.of((String)resolved));
                    continue;
                }
                if (indexLike instanceof Meta.Alias) {
                    if (scope.includeAliases) {
                        aliases.add((Object)((Meta.Alias)indexLike));
                        continue;
                    }
                    nonExistingIndices.add((Object)Meta.NonExistent.of((String)resolved));
                    continue;
                }
                if (indexLike instanceof Meta.DataStream) {
                    if (scope.includeDataStreams) {
                        dataStreams.add((Object)((Meta.DataStream)indexLike));
                        continue;
                    }
                    nonExistingIndices.add((Object)Meta.NonExistent.of((String)resolved));
                    continue;
                }
                if (scope.includeIndices) {
                    indices.add((Object)((Meta.Index)indexLike));
                    continue;
                }
                nonExistingIndices.add((Object)Meta.NonExistent.of((String)resolved));
            }
            ImmutableSet pureIndices = indices.build();
            if ((aliases.size() != 0 || dataStreams.size() != 0) && scope != ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY_DISTINCT) {
                pureIndices = pureIndices.matching(index -> {
                    if (index.parentDataStreamName() != null && dataStreams.contains((Object)index.parentDataStream())) {
                        return false;
                    }
                    return !aliases.containsAny((Set)index.parentAliases());
                });
            }
            return new Local((ImmutableSet<Meta.Index>)pureIndices, (ImmutableSet<Meta.Alias>)aliases.build(), (ImmutableSet<Meta.DataStream>)dataStreams.build(), (ImmutableSet<Meta.NonExistent>)nonExistingIndices.build());
        }

        static Local resolveDataStreamsWithoutPatterns(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            ImmutableSet.Builder dataStreams = new ImmutableSet.Builder();
            for (String index : request.localIndices) {
                String resolved = DateMathExpressionResolver.resolveExpression((String)index);
                if (ActionRequestIntrospector.containsWildcard(resolved)) continue;
                Meta.IndexLikeObject indexLike = indexMetadata.getIndexOrLike(resolved);
                if (indexLike == null) {
                    dataStreams.add((Object)Meta.DataStream.nonExistent((String)resolved));
                    continue;
                }
                if (!(indexLike instanceof Meta.DataStream)) continue;
                dataStreams.add((Object)((Meta.DataStream)indexLike));
            }
            return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)dataStreams.build(), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
        }

        static Local resolveAliasesWithoutPatterns(ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            ImmutableSet.Builder aliases = new ImmutableSet.Builder();
            for (String index : request.localIndices) {
                String resolved = DateMathExpressionResolver.resolveExpression((String)index);
                if (ActionRequestIntrospector.containsWildcard(resolved)) continue;
                Meta.IndexLikeObject indexLike = indexMetadata.getIndexOrLike(resolved);
                if (indexLike == null) {
                    aliases.add((Object)Meta.Alias.nonExistent((String)resolved));
                    continue;
                }
                if (!(indexLike instanceof Meta.Alias)) continue;
                aliases.add((Object)((Meta.Alias)indexLike));
            }
            return new Local((ImmutableSet<Meta.Index>)ImmutableSet.empty(), (ImmutableSet<Meta.Alias>)aliases.build(), (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.NonExistent>)ImmutableSet.empty());
        }

        private static ImmutableSet<String> resolveDateMathExpressions(Collection<String> indices) {
            ImmutableSet result = ImmutableSet.empty();
            for (String index : indices) {
                result = result.with((Object)DateMathExpressionResolver.resolveExpression((String)index));
            }
            return result;
        }

        public ImmutableSet<String> getUnionOfAliasesAndDataStreams() {
            return this.unionOfAliasesAndDataStreams;
        }

        public int hashCode() {
            return this.union.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Local) {
                return this.union.equals(((Local)obj).union);
            }
            return false;
        }

        private static void resolveNegationUpAndDown(String index, Set<String> excludeNames, Set<String> partiallyExcludedObjects, ActionRequestIntrospector.IndicesRequestInfo request, Meta indexMetadata) {
            Meta.IndexLikeObject indexLikeObject = indexMetadata.getIndexOrLike(index);
            if (request.isNegationOnlyEffectiveForIndices() && !(indexLikeObject instanceof Meta.Index)) {
                return;
            }
            excludeNames.add(index);
            if (indexLikeObject != null) {
                if (indexLikeObject.parentDataStreamName() != null) {
                    partiallyExcludedObjects.add(indexLikeObject.parentDataStreamName());
                }
                partiallyExcludedObjects.addAll(indexLikeObject.parentAliasNames());
                if (indexLikeObject instanceof Meta.IndexCollection) {
                    excludeNames.addAll((Collection<String>)((Meta.IndexCollection)indexLikeObject).resolveDeepToNames(Meta.Alias.ResolutionMode.NORMAL));
                    if (indexLikeObject instanceof Meta.Alias) {
                        excludeNames.addAll(((Meta.Alias)indexLikeObject).members().stream().map(Meta.IndexLikeObject::name).collect(Collectors.toList()));
                    }
                }
            }
        }
    }
}

