/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.config.net.CacheConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.google.common.io.BaseEncoding;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.util.Base64URL;
import java.text.ParseException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthTokenServiceConfig
implements PatchableDocument<AuthTokenServiceConfig> {
    private static final Logger log = LogManager.getLogger(AuthTokenServiceConfig.class);
    public static CType<AuthTokenServiceConfig> TYPE = new CType("auth_token_service", "Auth Token Service", 10021, AuthTokenServiceConfig.class, AuthTokenServiceConfig::parse, CType.Storage.OPTIONAL, CType.Arity.SINGLE);
    public static final String DEFAULT_AUDIENCE = "searchguard_tokenauth";
    static final CacheConfig DEFAULT_TOKEN_CACHE_CONFIG = new CacheConfig(true, Duration.ofMinutes(60L), null, null);
    static final String SIGNING_KEY_SECRET = "auth_tokens_signing_key_hs512";
    private boolean enabled;
    private JWK jwtSigningKey;
    private JWK jwtEncryptionKey;
    private String jwtAud;
    private TemporalAmount maxValidity;
    private List<String> excludeClusterPermissions = Arrays.asList("cluster:admin:searchguard:authtoken/_own/create");
    private int maxTokensPerUser = 100;
    private FreezePrivileges freezePrivileges = FreezePrivileges.USER_CHOOSES;
    private CacheConfig cacheConfig;
    private DocNode source;
    private static final ValidatingFunction<DocNode, JWK> JWK_SIGNING_KEY_PARSER = new ValidatingFunction<DocNode, JWK>(){

        public JWK apply(DocNode jsonNode) throws ConfigValidationException {
            try {
                String jwkJsonString = jsonNode.toJsonString();
                JWK result = JWK.parse((String)jwkJsonString);
                KeyUse publicKeyUse = result.getKeyUse();
                if (publicKeyUse != null && publicKeyUse != KeyUse.SIGNATURE) {
                    throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for signing"));
                }
                return result;
            }
            catch (ParseException e) {
                throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
            }
        }
    };
    private static final ValidatingFunction<DocNode, JWK> JWK_HS512_SIGNING_KEY_PARSER = new ValidatingFunction<DocNode, JWK>(){

        public JWK apply(DocNode jsonNode) throws ConfigValidationException {
            byte[] key;
            try {
                key = BaseEncoding.base64Url().decode((CharSequence)jsonNode.toString());
            }
            catch (Exception e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)").cause((Throwable)e));
            }
            if (key.length < 64) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 512 bit", (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)"));
            }
            return new OctetSequenceKey.Builder(key).algorithm(Algorithm.parse((String)"HS512")).keyUse(KeyUse.SIGNATURE).build();
        }
    };
    private static final ValidatingFunction<DocNode, JWK> JWK_ENCRYPTION_KEY_PARSER = new ValidatingFunction<DocNode, JWK>(){

        public JWK apply(DocNode jsonNode) throws ConfigValidationException {
            try {
                String jwkJsonString = jsonNode.toJsonString();
                JWK result = JWK.parse((String)jwkJsonString);
                KeyUse publicKeyUse = result.getKeyUse();
                if (publicKeyUse != null && publicKeyUse != KeyUse.ENCRYPTION) {
                    throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for encryption"));
                }
                return result;
            }
            catch (ParseException e) {
                throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
            }
        }
    };
    private static final ValidatingFunction<DocNode, JWK> JWK_A256KW_ENCRYPTION_KEY_PARSER_A256KW = new ValidatingFunction<DocNode, JWK>(){

        public JWK apply(DocNode jsonNode) throws ConfigValidationException {
            byte[] key;
            String value = jsonNode.toString();
            try {
                key = BaseEncoding.base64Url().decode((CharSequence)value);
            }
            catch (Exception e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)").cause((Throwable)e));
            }
            if (key.length < 32) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 256 bit", (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)"));
            }
            return new OctetSequenceKey.Builder(key).algorithm(Algorithm.parse((String)"A256KW")).keyUse(KeyUse.ENCRYPTION).build();
        }
    };

    public boolean isEnabled() {
        return this.enabled;
    }

    public JWK getJwtSigningKey() {
        return this.jwtSigningKey;
    }

    public JWK getJwtEncryptionKey() {
        return this.jwtEncryptionKey;
    }

    public String getJwtAud() {
        return this.jwtAud;
    }

    public TemporalAmount getMaxValidity() {
        return this.maxValidity;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJwtSigningKey(JWK jwtSigningKey) {
        this.jwtSigningKey = jwtSigningKey;
    }

    public void setJwtEncryptionKey(JWK jwtEncryptionKey) {
        this.jwtEncryptionKey = jwtEncryptionKey;
    }

    public void setJwtAud(String jwtAud) {
        this.jwtAud = jwtAud;
    }

    public void setMaxValidity(TemporalAmount maxValidity) {
        this.maxValidity = maxValidity;
    }

    public List<String> getExcludeClusterPermissions() {
        return this.excludeClusterPermissions;
    }

    public void setExcludeClusterPermissions(List<String> excludeClusterPermissions) {
        this.excludeClusterPermissions = excludeClusterPermissions;
    }

    public static ValidationResult<AuthTokenServiceConfig> parse(DocNode jsonNode, ConfigurationRepository.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors, (Parser.Context)context);
        VariableResolvers variableResolvers = context.variableResolvers();
        AuthTokenServiceConfig result = new AuthTokenServiceConfig();
        result.source = jsonNode;
        result.enabled = vJsonNode.get("enabled").withDefault(false).asBoolean();
        if (result.enabled) {
            if (vJsonNode.hasNonNull("jwt_signing_key")) {
                result.jwtSigningKey = (JWK)vJsonNode.get("jwt_signing_key").by(JWK_SIGNING_KEY_PARSER);
            } else if (vJsonNode.hasNonNull("jwt_signing_key_hs512")) {
                result.jwtSigningKey = (JWK)vJsonNode.get("jwt_signing_key_hs512").by(JWK_HS512_SIGNING_KEY_PARSER);
            } else {
                try {
                    Object key = ((ValidatingFunction)variableResolvers.toMap().get((Object)"var")).apply((Object)SIGNING_KEY_SECRET);
                    if (!(key instanceof String)) {
                        throw new ConfigValidationException(new ValidationError("jwt_signing_key_hs512", "Unexpected variable value for auth_tokens_signing_key_hs512"));
                    }
                    result.jwtSigningKey = new OctetSequenceKey.Builder(new Base64URL((String)key)).algorithm(Algorithm.parse((String)"HS512")).keyUse(KeyUse.SIGNATURE).build();
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(null, e);
                }
                catch (Exception e) {
                    validationErrors.add(new ValidationError(null, e.getMessage()).cause((Throwable)e));
                }
            }
            if (vJsonNode.hasNonNull("jwt_encryption_key")) {
                result.jwtEncryptionKey = (JWK)vJsonNode.get("jwt_encryption_key").by(JWK_ENCRYPTION_KEY_PARSER);
            } else if (vJsonNode.hasNonNull("jwt_encryption_key_a256kw")) {
                result.jwtEncryptionKey = (JWK)vJsonNode.get("jwt_encryption_key_a256kw").by(JWK_A256KW_ENCRYPTION_KEY_PARSER_A256KW);
            }
            result.cacheConfig = (CacheConfig)vJsonNode.get("token_cache").withDefault((Object)DEFAULT_TOKEN_CACHE_CONFIG).by(CacheConfig::new);
            result.jwtAud = vJsonNode.get("jwt_aud_claim").withDefault(DEFAULT_AUDIENCE).asString();
            result.maxValidity = vJsonNode.get("max_validity").asTemporalAmount();
            result.excludeClusterPermissions = vJsonNode.get("exclude_cluster_permissions").asList().withDefault(new String[]{"cluster:admin:searchguard:authtoken/_own/create"}).ofStrings();
            ImmutableList excludeIndexPermissions = vJsonNode.get("exclude_index_permissions").asListOfStrings();
            if (excludeIndexPermissions != null && !excludeIndexPermissions.isEmpty()) {
                if (context.isLenientValidationRequested()) {
                    log.error("exclude_index_permissions in sg_roles is no longer supported");
                } else {
                    validationErrors.add(new ValidationError("exclude_index_permissions", "This attribute is no longer supported"));
                }
            }
            result.maxTokensPerUser = vJsonNode.get("max_tokens_per_user").withDefault((Number)100).asInt();
            result.freezePrivileges = (FreezePrivileges)vJsonNode.get("freeze_privileges").withDefault((Enum)FreezePrivileges.USER_CHOOSES).asEnum(FreezePrivileges.class);
        }
        if (!validationErrors.hasErrors()) {
            return new ValidationResult((Object)result);
        }
        return new ValidationResult(validationErrors);
    }

    public int getMaxTokensPerUser() {
        return this.maxTokensPerUser;
    }

    public void setMaxTokensPerUser(int maxTokensPerUser) {
        this.maxTokensPerUser = maxTokensPerUser;
    }

    public FreezePrivileges getFreezePrivileges() {
        return this.freezePrivileges;
    }

    public void setFreezePrivileges(FreezePrivileges freezePrivileges) {
        this.freezePrivileges = freezePrivileges;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public AuthTokenServiceConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (AuthTokenServiceConfig)AuthTokenServiceConfig.parse(docNode, (ConfigurationRepository.Context)context).get();
    }

    public static enum FreezePrivileges {
        ALWAYS,
        NEVER,
        USER_CHOOSES;

    }
}

