/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common.auth;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.watch.common.auth.Auth;
import java.io.IOException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class BasicAuth
extends Auth {
    private String username;
    private String password;

    public BasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static BasicAuth create(DocNode jsonObject) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        String username = vJsonNode.get("username").required().asString();
        String password = vJsonNode.get("password").asString();
        validationErrors.throwExceptionForPresentErrors();
        return new BasicAuth(username, password);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", "basic");
        if (this.username != null) {
            builder.field("username", this.username);
        }
        if (this.password != null) {
            builder.field("password", this.password);
        }
        builder.endObject();
        return builder;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

