/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidator;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;

class FeMultiTenancyEnabledFlagValidator
extends ConfigModificationValidator<FeMultiTenancyConfig> {
    private static final Logger log = LogManager.getLogger(FeMultiTenancyEnabledFlagValidator.class);
    private static final String CONFIG_ENTRY_DEFAULT_KEY = "default";
    private final FeMultiTenancyConfigurationProvider feMultiTenancyConfigurationProvider;
    private final ClusterService clusterService;

    FeMultiTenancyEnabledFlagValidator(FeMultiTenancyConfigurationProvider feMultiTenancyConfigurationProvider, ClusterService clusterService, ConfigurationRepository configurationRepository) {
        super(FeMultiTenancyConfig.TYPE, configurationRepository);
        this.feMultiTenancyConfigurationProvider = Objects.requireNonNull(feMultiTenancyConfigurationProvider, "Fe multi tenancy configuration provider is required");
        this.clusterService = Objects.requireNonNull(clusterService, "Cluster service is required");
    }

    public List<ValidationError> validateConfigs(List<SgDynamicConfiguration<?>> newConfigs) {
        List notNullConfigs = ((List)Optional.ofNullable(newConfigs).orElse(new ArrayList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Optional newFeMtConfig = this.findConfigOfType(FeMultiTenancyConfig.class, notNullConfigs);
        newFeMtConfig.flatMap(this::validateMultiTenancyEnabledFlag).ifPresent(errors::add);
        return errors;
    }

    public List<ValidationError> validateConfig(SgDynamicConfiguration<?> newConfig) {
        return this.validateConfigs(Collections.singletonList(newConfig));
    }

    public <T> List<ValidationError> validateConfigEntry(T newConfigEntry) {
        if (Objects.nonNull(newConfigEntry)) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            if (FeMultiTenancyConfig.class.isAssignableFrom(newConfigEntry.getClass())) {
                FeMultiTenancyConfig currentConfig = this.getCurrentConfiguration();
                this.validateEntryEnabledFlag(null, (FeMultiTenancyConfig)newConfigEntry, currentConfig).ifPresent(errors::add);
            }
            return errors;
        }
        return Collections.emptyList();
    }

    private Optional<ValidationError> validateMultiTenancyEnabledFlag(SgDynamicConfiguration<FeMultiTenancyConfig> feMtConfig) {
        FeMultiTenancyConfig currentCfg = this.getCurrentConfiguration();
        return Optional.of(feMtConfig).map(config -> (FeMultiTenancyConfig)config.getCEntry(CONFIG_ENTRY_DEFAULT_KEY)).flatMap(config -> this.validateEntryEnabledFlag(CONFIG_ENTRY_DEFAULT_KEY, (FeMultiTenancyConfig)config, currentCfg));
    }

    private Optional<ValidationError> validateEntryEnabledFlag(String configEntryKey, FeMultiTenancyConfig newConfig, FeMultiTenancyConfig currentConfig) {
        if (currentConfig.isEnabled() && newConfig.isDisabled() && this.anyKibanaIndexExists()) {
            String msg = "Cannot change the value of the 'enabled' flag to 'false'. Multitenancy cannot be disabled, please contact the support team.";
            return Optional.of(this.toValidationError(configEntryKey, msg));
        }
        if (currentConfig.isDisabled() && newConfig.isEnabled() && this.anyKibanaIndexExists()) {
            String msg = "You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed.";
            return Optional.of(this.toValidationError(configEntryKey, msg));
        }
        return Optional.empty();
    }

    private boolean anyKibanaIndexExists() {
        String kibanaIndexNamePrefix = Objects.requireNonNullElse(this.feMultiTenancyConfigurationProvider.getKibanaIndex(), FeMultiTenancyConfig.DEFAULT.getIndex());
        return this.clusterService.state().metadata().getProject().getIndicesLookup().keySet().stream().anyMatch(name -> name.startsWith(kibanaIndexNamePrefix));
    }

    private FeMultiTenancyConfig getCurrentConfiguration() {
        return this.findCurrentConfiguration(FeMultiTenancyConfig.TYPE).map(currentConfig -> (FeMultiTenancyConfig)currentConfig.getCEntry(CONFIG_ENTRY_DEFAULT_KEY)).orElseGet(() -> {
            log.warn("{} config is unavailable, default config will be used instead", (Object)FeMultiTenancyConfig.TYPE.getName());
            return FeMultiTenancyConfig.DEFAULT;
        });
    }
}

