/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexNameDataFormatter;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;

class PopulateBackupIndicesStep
implements MigrationStep {
    private static final Logger log = LogManager.getLogger(PopulateBackupIndicesStep.class);
    private final StepRepository repository;

    public PopulateBackupIndicesStep(StepRepository repository) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        Optional<GetIndexResponse> responseOptional = this.repository.findIndexByNameOrAlias("backup_fe_migration_to_8_8_0_*");
        responseOptional.ifPresentOrElse(response -> {
            List sortedIndices = Arrays.stream(response.getIndices()).sorted(this.backupIndexComparator()).collect(Collectors.toList());
            context.setBackupIndices((ImmutableList<String>)ImmutableList.of(sortedIndices));
        }, () -> context.setBackupIndices((ImmutableList<String>)ImmutableList.empty()));
        ImmutableList<String> backupIndices = context.getBackupIndices();
        String indicesString = backupIndices.stream().map(name -> "'" + name + "'").collect(Collectors.joining(", "));
        return new StepResult(StepExecutionStatus.OK, "Found " + backupIndices.size() + " backup indices", "Backup indices: " + indicesString);
    }

    private Comparator<String> backupIndexComparator() {
        return (indexOne, indexTwo) -> {
            LocalDateTime localDateOne = this.extractDateFromIndexName((String)indexOne);
            LocalDateTime localDateTwo = this.extractDateFromIndexName((String)indexTwo);
            return localDateTwo.compareTo(localDateOne);
        };
    }

    private LocalDateTime extractDateFromIndexName(String indexName) {
        if (!indexName.startsWith("backup_fe_migration_to_8_8_0_")) {
            String message = "Backup index name does not start with prefix backup_fe_migration_to_8_8_0_";
            String details = "Invalid index name '" + indexName + "'";
            throw new StepException(message, StepExecutionStatus.INVALID_BACKUP_INDEX_NAME_ERROR, details);
        }
        String datePart = indexName.substring("backup_fe_migration_to_8_8_0_".length());
        try {
            return IndexNameDataFormatter.parse(datePart);
        }
        catch (DateTimeParseException ex) {
            log.error("Cannot parse date from backup index name '{}'.", (Object)indexName, (Object)ex);
            String message = "Cannot extract data from backup index name";
            String details = "Index name '" + indexName + "'";
            throw new StepException(message, StepExecutionStatus.INVALID_DATE_IN_BACKUP_INDEX_NAME_ERROR, details);
        }
    }

    @Override
    public String name() {
        return "find backup indices";
    }
}

