/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGKey;
import com.floragunn.searchguard.lpg.BCPGObject;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import java.io.IOException;

public abstract class OctetArrayBCPGKey
extends BCPGObject
implements BCPGKey {
    private final byte[] key;

    OctetArrayBCPGKey(int length, BCPGInputStream in) throws IOException {
        this.key = new byte[length];
        in.readFully(this.key);
    }

    OctetArrayBCPGKey(int length, byte[] key) {
        if (key.length != length) {
            throw new IllegalArgumentException("unexpected key encoding length: expected " + length + " bytes, got " + key.length);
        }
        this.key = new byte[length];
        System.arraycopy(key, 0, this.key, 0, length);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.write(this.key);
    }

    public byte[] getKey() {
        return Arrays.clone(this.key);
    }
}

