/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.search;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchAccountRequest
extends ActionRequest {
    private SearchSourceBuilder searchSourceBuilder;
    private TimeValue scroll;
    private int from = -1;
    private int size = -1;

    public SearchAccountRequest() {
    }

    public SearchAccountRequest(SearchSourceBuilder searchSourceBuilder, TimeValue scroll) {
        this.searchSourceBuilder = searchSourceBuilder;
        this.scroll = scroll;
    }

    public SearchAccountRequest(StreamInput in) throws IOException {
        super(in);
        this.scroll = in.readOptionalTimeValue();
        this.from = in.readInt();
        this.size = in.readInt();
        this.searchSourceBuilder = (SearchSourceBuilder)in.readOptionalWriteable(SearchSourceBuilder::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalTimeValue(this.scroll);
        out.writeInt(this.from);
        out.writeInt(this.size);
        out.writeOptionalWriteable((Writeable)this.searchSourceBuilder);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    public TimeValue getScroll() {
        return this.scroll;
    }

    public void setSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
        this.searchSourceBuilder = searchSourceBuilder;
    }

    public void setScroll(TimeValue scroll) {
        this.scroll = scroll;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

