/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.signals.truststore.rest.TruststoreRepresentation;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.common.time.DateFormatter;

public class CertificateRepresentation
implements Document<TruststoreRepresentation> {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    public static final String FIELD_SERIAL_NUMBER = "serial_number";
    public static final String FIELD_NOT_BEFORE = "not_before";
    public static final String FIELD_NOT_AFTER = "not_after";
    public static final String FIELD_ISSUER = "issuer";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_PEM = "pem";
    private final String serialNumber;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String issuer;
    private final String subject;
    private final String pem;

    public CertificateRepresentation(String serialNumber, Instant notBefore, Instant notAfter, String issuer, String subject, String pem) {
        this.serialNumber = serialNumber;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.issuer = issuer;
        this.subject = subject;
        this.pem = pem;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPem() {
        return this.pem;
    }

    public ImmutableMap<String, Object> toBasicObject() {
        return ImmutableMap.of((Object)FIELD_SERIAL_NUMBER, (Object)this.serialNumber).with((Object)FIELD_NOT_BEFORE, (Object)this.formatNullableDate(this.notBefore)).with((Object)FIELD_NOT_AFTER, (Object)this.formatNullableDate(this.notAfter)).with((Object)FIELD_ISSUER, (Object)this.issuer).with((Object)FIELD_SUBJECT, (Object)this.subject).with((Object)FIELD_PEM, (Object)this.pem);
    }

    private String formatNullableDate(TemporalAccessor date) {
        return date != null ? DATE_FORMATTER.format(date) : null;
    }
}

