/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

@FunctionalInterface
public interface ThrowingBiFunction<T1, T2, R, E extends Exception> {
    public R apply(T1 var1, T2 var2) throws E;

    public static <T1, T2, R> BiFunction<T1, T2, R> unchecked(ThrowingBiFunction<T1, T2, R, ?> function) {
        return Objects.requireNonNull(function).unchecked();
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> sneaky(ThrowingBiFunction<? super T1, ? super T2, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return (t1, t2) -> {
            try {
                return function.apply(t1, t2);
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    public static <T1, T2, R> BiFunction<T1, T2, Optional<R>> lifted(ThrowingBiFunction<T1, T2, R, ?> f) {
        return Objects.requireNonNull(f).lift();
    }

    default public <V> ThrowingBiFunction<T1, T2, V, E> andThen(ThrowingFunction<? super R, ? extends V, ? extends E> after) {
        Objects.requireNonNull(after);
        return (arg1, arg2) -> after.apply((R)this.apply(arg1, arg2));
    }

    default public BiFunction<T1, T2, R> unchecked() {
        return (arg1, arg2) -> {
            try {
                return this.apply(arg1, arg2);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }

    default public BiFunction<T1, T2, Optional<R>> lift() {
        return (arg1, arg2) -> {
            try {
                return Optional.ofNullable(this.apply(arg1, arg2));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }
}

