/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Set;
import org.elasticsearch.common.unit.ByteSizeValue;

public class RestrictedActionAuthorization
implements ActionAuthorization {
    private final ActionAuthorization base;
    private final ActionAuthorization restrictionSgRoles;
    private final RequestedPrivileges restriction;

    RestrictedActionAuthorization(ActionAuthorization base, RequestedPrivileges restriction, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta meta, Set<String> tenants, ByteSizeValue statefulIndexMaxHeapSize) {
        this.base = base;
        this.restriction = restriction;
        this.restrictionSgRoles = new RoleBasedActionAuthorization(restriction.toRolesConfig(), actionGroups, actions, meta, tenants, statefulIndexMaxHeapSize);
    }

    public PrivilegesEvaluationResult hasClusterPermission(PrivilegesEvaluationContext context, Action action) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.restrictionSgRoles.hasClusterPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), action);
        if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return result.reason("Privilege was not requested for token");
        }
        return this.base.hasClusterPermission(context, action);
    }

    public PrivilegesEvaluationResult hasIndexPermission(PrivilegesEvaluationContext context, Action primaryAction, ImmutableSet<Action> actions, ResolvedIndices resolvedIndices, Action.Scope scope) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult restrictedPermission = this.restrictionSgRoles.hasIndexPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), primaryAction, actions, resolvedIndices, scope);
        if (restrictedPermission.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return restrictedPermission.reason("Privilege was not requested for token");
        }
        return this.base.hasIndexPermission(context, primaryAction, actions, resolvedIndices, scope);
    }

    public PrivilegesEvaluationResult hasTenantPermission(PrivilegesEvaluationContext context, Action action, String requestedTenant) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.restrictionSgRoles.hasTenantPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), action, requestedTenant);
        if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return result.reason("Privilege was not requested for token");
        }
        return this.base.hasTenantPermission(context, action, requestedTenant);
    }

    public String toString() {
        return "RestrictedActionAuthorization [base=" + String.valueOf(this.base) + ", restrictionSgRoles=" + String.valueOf(this.restrictionSgRoles) + ", restriction=" + String.valueOf(this.restriction) + "]";
    }
}

