/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.codova.config.net.CacheConfig;
import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.ldap.LDAP;
import com.floragunn.searchguard.enterprise.auth.ldap.SearchFilter;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.google.common.cache.Cache;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupSearch {
    private final String searchBaseDn;
    private final SearchScope searchScope;
    private final SearchFilter searchFilter;
    private final String[] retrieveAttributes;
    private final boolean recursive;
    private final Pattern recursivePattern;
    private final SearchFilter recursiveSearchFilter;
    private final String[] recursiveRetrieveAttributes;
    private final int maxRecusionDepth;
    private final String roleNameAttribute;
    private final Cache<Filter, Set<Entry>> searchCache;

    GroupSearch(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        this.searchBaseDn = vNode.get("base_dn").required().asString();
        this.searchScope = (SearchScope)vNode.get("scope").withDefault((Object)SearchScope.SUB).byString(LDAP::getSearchScope);
        this.searchFilter = (SearchFilter)vNode.get("filter").withDefault((Object)SearchFilter.DEFAULT_GROUP_SEARCH).by(SearchFilter::parseForGroupSearch);
        this.roleNameAttribute = vNode.get("role_name_attribute").withDefault("dn").asString();
        this.retrieveAttributes = (String[])vNode.get("retrieve_attributes").withListDefault(new String[]{"+", "*"}).ofStrings().toArray((Object[])new String[0]);
        this.recursive = vNode.get("recursive.enabled").withDefault(false).asBoolean();
        this.recursiveSearchFilter = (SearchFilter)vNode.get("recursive.filter").withDefault((Object)this.searchFilter).by(SearchFilter::parseForGroupSearch);
        this.recursivePattern = (Pattern)vNode.get("recursive.enabled_for").by(Pattern::parse);
        this.recursiveRetrieveAttributes = (String[])vNode.get("recursive.retrieve_attributes").withListDefault(this.retrieveAttributes).ofStrings().toArray((Object[])new String[0]);
        this.maxRecusionDepth = vNode.get("recursive.max_depth").withDefault((Number)30).asInt();
        this.searchCache = ((CacheConfig)vNode.get("cache").withDefault((Object)CacheConfig.DEFAULT).by(CacheConfig::new)).build();
        validationErrors.throwExceptionForPresentErrors();
    }

    Set<Entry> search(LDAPConnection connection, String dn, AttributeSource attributeSource, Meter meter) throws AuthenticatorUnavailableException {
        return new SearchState(connection, attributeSource, meter).search(dn);
    }

    public String getRoleNameAttribute() {
        return this.roleNameAttribute;
    }

    class SearchState {
        private final LDAPConnection connection;
        private final AttributeSource attributeSource;
        private final Meter meter;
        private Map<String, Entry> foundEntries = new HashMap<String, Entry>();

        SearchState(LDAPConnection connection, AttributeSource attributeSource, Meter meter) {
            this.connection = connection;
            this.attributeSource = attributeSource;
            this.meter = meter;
        }

        Set<Entry> search(String dn) throws AuthenticatorUnavailableException {
            Set cachedResult;
            Filter filter;
            AttributeSource attributeSource = dn != null ? AttributeSource.joined((AttributeSource[])new AttributeSource[]{AttributeSource.of((String)"dn", (Object)dn), this.attributeSource}) : this.attributeSource;
            try {
                filter = GroupSearch.this.searchFilter.toFilter(attributeSource);
            }
            catch (ExpressionEvaluationException | LDAPException e) {
                throw new AuthenticatorUnavailableException("Could not create query for LDAP group search", e.getMessage(), e);
            }
            if (GroupSearch.this.searchCache != null && (cachedResult = (Set)GroupSearch.this.searchCache.getIfPresent((Object)filter)) != null) {
                return cachedResult;
            }
            SearchRequest searchRequest = new SearchRequest(GroupSearch.this.searchBaseDn, GroupSearch.this.searchScope, filter, GroupSearch.this.retrieveAttributes);
            searchRequest.setDerefPolicy(DereferencePolicy.ALWAYS);
            try {
                HashSet<String> newEntryDns = new HashSet<String>();
                try (Meter subMeter = this.meter.detail("ldap_search_operation");){
                    List searchResult = this.connection.search(searchRequest).getSearchEntries();
                    subMeter.count("search_result_entries", (long)searchResult.size());
                    for (SearchResultEntry entry : searchResult) {
                        this.foundEntries.put(entry.getDN(), (Entry)entry);
                        if (GroupSearch.this.recursivePattern != null && !GroupSearch.this.recursivePattern.matches(entry.getDN())) continue;
                        newEntryDns.add(entry.getDN());
                    }
                }
                if (GroupSearch.this.recursive && newEntryDns.size() != 0) {
                    this.searchNested(newEntryDns, 0);
                }
                ImmutableSet result = ImmutableSet.of(this.foundEntries.values());
                if (GroupSearch.this.searchCache != null) {
                    GroupSearch.this.searchCache.put((Object)filter, (Object)result);
                }
                return result;
            }
            catch (LDAPException e) {
                throw new AuthenticatorUnavailableException("LDAP group search failed", LDAP.getBetterErrorMessage(e), (Throwable)e).details((Map)LDAP.getDetailsFrom(e).with((Object)"ldap_group_base_dn", (Object)GroupSearch.this.searchBaseDn).with((Object)"ldap_filter", (Object)filter.toString()));
            }
        }

        void searchNested(Set<String> dnSet, int currentDepth) throws AuthenticatorUnavailableException {
            HashSet<String> newEntryDns = new HashSet<String>();
            try (Meter subMeter = this.meter.detail("recursive_search");){
                ArrayList<Filter> filters = new ArrayList<Filter>(dnSet.size());
                for (String dn : dnSet) {
                    AttributeSource attributeSource = AttributeSource.joined((AttributeSource[])new AttributeSource[]{AttributeSource.of((String)"dn", (Object)dn), this.attributeSource});
                    try {
                        filters.add(GroupSearch.this.recursiveSearchFilter.toFilter(attributeSource));
                    }
                    catch (ExpressionEvaluationException | LDAPException e) {
                        throw new AuthenticatorUnavailableException("Could not create query for LDAP group search", e.getMessage(), e);
                    }
                }
                Filter filter = Filter.createORFilter(filters);
                try (Meter subSubMeter = subMeter.detail("ldap_search_operation");){
                    SearchRequest searchRequest = new SearchRequest(GroupSearch.this.searchBaseDn, GroupSearch.this.searchScope, filter, GroupSearch.this.recursiveRetrieveAttributes);
                    searchRequest.setDerefPolicy(DereferencePolicy.ALWAYS);
                    List searchResult = this.connection.search(searchRequest).getSearchEntries();
                    subSubMeter.count("search_result_entries", (long)searchResult.size());
                    for (SearchResultEntry entry : searchResult) {
                        if (this.foundEntries.containsKey(entry.getDN())) continue;
                        this.foundEntries.put(entry.getDN(), (Entry)entry);
                        if (GroupSearch.this.recursivePattern != null && !GroupSearch.this.recursivePattern.matches(entry.getDN())) continue;
                        newEntryDns.add(entry.getDN());
                    }
                }
                catch (LDAPException e) {
                    throw new AuthenticatorUnavailableException("LDAP group search failed", LDAP.getBetterErrorMessage(e), (Throwable)e).details((Map)LDAP.getDetailsFrom(e).with((Object)"ldap_group_base_dn", (Object)GroupSearch.this.searchBaseDn).with((Object)"ldap_filter", (Object)filter.toString()));
                }
            }
            if (newEntryDns.size() != 0 && currentDepth < GroupSearch.this.maxRecusionDepth) {
                this.searchNested(newEntryDns, currentDepth + 1);
            }
        }
    }
}

