/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.stream.Collectors;

public class LDAP {
    static SearchScope getSearchScope(String name) throws ConfigValidationException {
        for (SearchScope searchScope : SearchScope.values()) {
            if (!searchScope.getName().equalsIgnoreCase(name)) continue;
            return searchScope;
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)name, (Object)Arrays.asList(SearchScope.values()).stream().map(s -> s.getName()).collect(Collectors.joining("|"))));
    }

    static OrderedImmutableMap<String, Object> getDetailsFrom(LDAPException e) {
        OrderedImmutableMap.Builder result = new OrderedImmutableMap.Builder();
        if (e.getResultCode() != null) {
            result.put((Object)"ldap_rc", (Object)e.getResultCode().toString());
        }
        if (e.getMatchedDN() != null) {
            result.put((Object)"matched_dn", (Object)e.getMatchedDN());
        }
        if (e.getDiagnosticMessage() != null) {
            result.put((Object)"diagnostic_message", (Object)e.getDiagnosticMessage());
        }
        if (e.getReferralURLs() != null && e.getReferralURLs().length > 0) {
            result.put((Object)"referral_urls", (Object)Arrays.asList(e.getReferralURLs()).toString());
        }
        if (e instanceof LDAPBindException && ((LDAPBindException)e).getBindResult() != null) {
            result.put((Object)"bind_result", (Object)((LDAPBindException)e).getBindResult().toString());
        }
        if (e instanceof LDAPSearchException) {
            LDAPSearchException searchException = (LDAPSearchException)e;
            result.put((Object)"entry_count", (Object)searchException.getEntryCount());
            result.put((Object)"reference_count", (Object)searchException.getReferenceCount());
        }
        return result.build();
    }

    static String getBetterErrorMessage(LDAPException e) {
        ResultCode resultCode = e.getResultCode();
        if (resultCode == null) {
            if (e.getExceptionMessage() != null) {
                return e.getExceptionMessage();
            }
            return e.getMessage();
        }
        switch (resultCode.intValue()) {
            case 32: {
                return e.getMessage() + "\nPlease verify that the base_dn setting is correct.";
            }
        }
        if (e.getExceptionMessage() != null) {
            return e.getExceptionMessage();
        }
        return e.getMessage();
    }
}

