/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateNodeResponse;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateNodeResponse, TransportConfigUpdateAction> {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ConfigurationRepository configurationRepository;

    @Inject
    public TransportConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ConfigurationRepository configurationRepository, ActionFilters actionFilters, GuiceDependencies guiceDependencies, IndicesService indicesService, RepositoriesService repositoriesService) {
        super("cluster:admin/searchguard/config/update", clusterService, transportService, actionFilters, NodeConfigUpdateRequest::new, (Executor)threadPool.executor("management"));
        guiceDependencies.setTransportService(transportService);
        guiceDependencies.setIndicesService(indicesService);
        guiceDependencies.setRepositoriesService(repositoriesService);
        this.configurationRepository = configurationRepository;
    }

    protected ConfigUpdateNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ConfigUpdateNodeResponse(in);
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, List<ConfigUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new ConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ConfigUpdateNodeResponse nodeOperation(NodeConfigUpdateRequest request, Task task) {
        try {
            this.configurationRepository.reloadConfiguration(CType.fromStringValues(request.configTypes), "Config Update " + String.valueOf((Object)request));
            return new ConfigUpdateNodeResponse(this.clusterService.localNode(), request.configTypes, null);
        }
        catch (Exception e) {
            this.logger.error("Error in TransportConfigUpdateAction nodeOperation for " + String.valueOf((Object)request), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected NodeConfigUpdateRequest newNodeRequest(ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(request);
    }

    public static class NodeConfigUpdateRequest
    extends AbstractTransportRequest {
        private String[] configTypes;

        public NodeConfigUpdateRequest(StreamInput in) throws IOException {
            super(in);
            this.configTypes = in.readStringArray();
        }

        public NodeConfigUpdateRequest(ConfigUpdateRequest request) {
            this.configTypes = request.getConfigTypes();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.configTypes);
        }
    }
}

