/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.modules.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetComponentStateAction
extends ActionType<Response> {
    private static final Logger log = LogManager.getLogger(GetComponentStateAction.class);
    public static final GetComponentStateAction INSTANCE = new GetComponentStateAction();
    public static final String NAME = "cluster:admin/searchguard/components/state";

    protected GetComponentStateAction() {
        super(NAME);
    }

    public static class TransportAction
    extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse, GetComponentStateAction> {
        private SearchGuardModulesRegistry modulesRegistry;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchGuardModulesRegistry modulesRegistry) {
            super(GetComponentStateAction.NAME, clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
            this.modulesRegistry = modulesRegistry;
        }

        protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            return new NodeResponse(in);
        }

        protected Response newResponse(Request request, List<NodeResponse> responses, List<FailedNodeException> failures) {
            return new Response(this.clusterService.getClusterName(), responses, failures);
        }

        protected NodeResponse nodeOperation(NodeRequest request, Task task) {
            if (request.moduleId != null && !request.moduleId.equals("_all")) {
                ComponentState componentState = this.modulesRegistry.getComponentState(request.moduleId);
                if (componentState != null) {
                    return new NodeResponse(this.clusterService.localNode(), Collections.singletonList(componentState));
                }
                return new NodeResponse(this.clusterService.localNode(), Collections.emptyList());
            }
            return new NodeResponse(this.clusterService.localNode(), this.modulesRegistry.getComponentStates());
        }

        protected NodeRequest newNodeRequest(Request request) {
            return new NodeRequest(request);
        }
    }

    public static enum Health {
        GREEN,
        YELLOW,
        RED;

    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private String message;
        private String detailJson;
        private List<ComponentState> states;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.message = in.readOptionalString();
            this.detailJson = in.readOptionalString();
            try {
                ImmutableList stateNodes = DocNode.parse((Format)Format.SMILE).from(in.readByteArray()).toListOfNodes();
                ArrayList<ComponentState> states = new ArrayList<ComponentState>(stateNodes.size());
                for (DocNode stateNode : stateNodes) {
                    try {
                        states.add(new ComponentState(stateNode));
                    }
                    catch (Exception e) {
                        log.error("Error while parsing state " + String.valueOf(stateNode), (Throwable)e);
                    }
                }
                this.states = states;
            }
            catch (Exception e) {
                log.error("Error while parsing states", (Throwable)e);
                this.states = Collections.emptyList();
            }
        }

        public NodeResponse(DiscoveryNode node, List<ComponentState> states, String message, String detailJson) {
            super(node);
            this.states = states;
            this.message = message;
            this.detailJson = detailJson;
        }

        public NodeResponse(DiscoveryNode node, List<ComponentState> states) {
            this(node, states, null, null);
        }

        public String getMessage() {
            return this.message;
        }

        public String getDetailJson() {
            return this.detailJson;
        }

        public List<ComponentState> getStates() {
            return this.states;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.message);
            out.writeOptionalString(this.detailJson);
            out.writeByteArray(DocWriter.smile().writeAsBytes(this.states));
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements ToXContentObject,
    Document<Response> {
        private String message;
        private Health health;
        private List<ComponentState> mergedComponentState;

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        public void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public List<ComponentState> getMergedComponentState() {
            this.initMergedComponentState();
            return this.mergedComponentState;
        }

        public String getMessage() {
            this.initMergedComponentState();
            return this.message;
        }

        public Map<String, Set<String>> getComponentsGroupedByLicense() {
            LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
            for (ComponentState componentState : this.getMergedComponentState()) {
                Response.getComponentsGroupedByLicense(componentState, result);
            }
            return result;
        }

        private static void getComponentsGroupedByLicense(ComponentState componentState, Map<String, Set<String>> result) {
            String requiredLicense = componentState.getLicenseRequiredInfo();
            if (!"no".equals(requiredLicense)) {
                result.computeIfAbsent(requiredLicense, k -> new HashSet()).add(componentState.getTypeAndName());
            }
            if (componentState.getParts() != null) {
                for (ComponentState part : componentState.getParts()) {
                    Response.getComponentsGroupedByLicense(part, result);
                }
            }
        }

        private void initMergedComponentState() {
            if (this.mergedComponentState != null) {
                return;
            }
            HashMap<String, ComponentState> map = new HashMap<String, ComponentState>();
            ArrayList<CallSite> infoMessages = new ArrayList<CallSite>();
            int total = 0;
            int completelyFailed = 0;
            int partiallyFailed = 0;
            int versionMismatch = 0;
            HashSet<CallSite> partiallyFailedMessages = new HashSet<CallSite>();
            HashSet<CallSite> versionMismatchMessages = new HashSet<CallSite>();
            ComponentState configRepoComponentState = null;
            for (NodeResponse nodeResponse : this.getNodes()) {
                try {
                    for (ComponentState componentState : nodeResponse.getStates()) {
                        ComponentState mergedComponentState = (ComponentState)map.get(componentState.getKey());
                        if (mergedComponentState == null) {
                            mergedComponentState = new ComponentState(componentState.getSortPrio(), componentState.getType(), componentState.getName());
                            map.put(mergedComponentState.getKey(), mergedComponentState);
                        }
                        componentState.setNodeId(nodeResponse.getNode().getId());
                        componentState.setNodeName(nodeResponse.getNode().getName());
                        mergedComponentState.addPart(componentState);
                        if (componentState.getMetrics().isEmpty()) continue;
                        for (Map.Entry entry : componentState.getMetrics().entrySet()) {
                            Measurement existing = (Measurement)mergedComponentState.getMetrics().get(entry.getKey());
                            if (existing == null) {
                                mergedComponentState.addMetrics((String)entry.getKey(), ((Measurement)entry.getValue()).clone());
                                continue;
                            }
                            existing.addToThis((Measurement)entry.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Error while processing nodeResponse " + String.valueOf((Object)nodeResponse), (Throwable)e);
                    infoMessages.add((CallSite)((Object)("Response from " + String.valueOf((Object)nodeResponse) + " could not be processed: " + e.getMessage())));
                }
            }
            ArrayList result = new ArrayList(map.values());
            result.sort((s1, s2) -> s1.getSortingKey().compareTo(s2.getSortingKey()));
            for (ComponentState mergedComponentState : result) {
                Instant minStart;
                ComponentState.PartsStats partsStats;
                ++total;
                if ("config_repository".equals(mergedComponentState.getName())) {
                    configRepoComponentState = mergedComponentState;
                }
                if ((partsStats = mergedComponentState.updateStateFromParts()).getFailed() >= partsStats.getMandatory()) {
                    mergedComponentState.setMessage("Initialization failed for all nodes");
                    ++completelyFailed;
                } else if (partsStats.getFailed() == 1) {
                    ComponentState failed = mergedComponentState.findPart(s -> s.isFailed());
                    mergedComponentState.setMessage("Initialization failed for node " + failed.getNodeId());
                    partiallyFailedMessages.add((CallSite)((Object)("Initialization failed for node " + failed.getNodeId())));
                    ++partiallyFailed;
                } else if (partsStats.getFailed() != 0) {
                    ++partiallyFailed;
                    mergedComponentState.setMessage("Initialization failed for " + partsStats.getFailed() + " nodes");
                    partiallyFailedMessages.add((CallSite)((Object)("Initialization failed for " + partsStats.getFailed() + " nodes")));
                }
                Map<String, Long> countedVersions = mergedComponentState.getParts().stream().collect(Collectors.groupingBy(state -> state.getJarVersion() != null ? state.getJarVersion() : "unknown", Collectors.counting()));
                if (countedVersions.size() > 1) {
                    ++versionMismatch;
                    Optional<Map.Entry> maxEntry = countedVersions.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue));
                    String maxVersion = (String)maxEntry.get().getKey();
                    ArrayListMultimap versionToNodeMap = ArrayListMultimap.create();
                    for (ComponentState part : mergedComponentState.getParts()) {
                        versionToNodeMap.put((Object)part.getJarVersion(), (Object)part.getNodeName());
                    }
                    if (countedVersions.size() == 2 && versionToNodeMap.size() == 1) {
                        Map.Entry other = (Map.Entry)versionToNodeMap.entries().iterator().next();
                        mergedComponentState.addDetail((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, node " + (String)other.getValue() + " uses " + (String)other.getKey()));
                        versionMismatchMessages.add((CallSite)((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, node " + (String)other.getValue() + " uses " + (String)other.getKey())));
                    } else if (countedVersions.size() == 2) {
                        String otherVersion = (String)((Map.Entry)versionToNodeMap.entries().iterator().next()).getKey();
                        Collection nodes = versionToNodeMap.get((Object)otherVersion);
                        if (nodes.size() <= 4) {
                            mergedComponentState.addDetail((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, version " + otherVersion + " is used by nodes " + String.join((CharSequence)", ", nodes)));
                            versionMismatchMessages.add((CallSite)((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, version " + otherVersion + " is used by nodes " + String.join((CharSequence)", ", nodes))));
                        } else {
                            mergedComponentState.addDetail((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, version " + otherVersion + " is used by " + nodes.size() + "nodes. See below for details."));
                            versionMismatchMessages.add((CallSite)((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, version " + otherVersion + " is used by " + nodes.size() + "nodes. See below for details.")));
                        }
                    } else {
                        mergedComponentState.addDetail((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, " + countedVersions.size() + " other versions are also in use. See below for details."));
                        versionMismatchMessages.add((CallSite)((Object)("Version mismatch: Most nodes use " + maxVersion + "; however, " + countedVersions.size() + " other versions are also in use. See below for details.")));
                    }
                }
                if ((minStart = mergedComponentState.getMinStartForInitializingState()) == null || !minStart.plus(5L, ChronoUnit.MINUTES).isBefore(Instant.now())) continue;
                long diff = (Instant.now().toEpochMilli() - minStart.toEpochMilli()) / 1000L / 60L;
                mergedComponentState.addDetail((Object)("A component is in state 'initializing' since " + diff + " minutes. See below for details."));
            }
            this.mergedComponentState = result;
            if (configRepoComponentState != null && !configRepoComponentState.isInitialized()) {
                this.message = configRepoComponentState.isFailed() ? "Search Guard configuration could not be initialized" : "Search Guard configuration has not been initialized, yet";
                this.health = Health.RED;
            } else if (total == 0) {
                this.message = "No components found";
                this.health = Health.RED;
            } else if (completelyFailed == 0 && partiallyFailed == 0) {
                this.health = Health.GREEN;
            } else if (completelyFailed == total) {
                this.message = "All components have failed on all nodes";
                this.health = Health.RED;
            } else if (completelyFailed > 0) {
                this.message = "Some components have failed on all nodes; see below for details";
                this.health = Health.YELLOW;
            } else if (partiallyFailed > 0) {
                this.message = partiallyFailedMessages.size() == 1 ? (String)partiallyFailedMessages.iterator().next() + "; see below for details" : "Components have failed on various nodes; see below for detail";
                this.health = Health.YELLOW;
            } else if (versionMismatch > 0) {
                this.message = versionMismatchMessages.size() == 1 ? (String)versionMismatchMessages.iterator().next() : "Several version mismatches were detected; see below for details";
                this.health = Health.YELLOW;
            }
        }

        public Map<String, Object> toBasicObject() {
            return OrderedImmutableMap.ofNonNull((Object)"health", (Object)((Object)this.getHealth()), (Object)"message", (Object)this.getMessage(), (Object)"components", this.getMergedComponentState());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.value(this.toDeepBasicObject());
            return builder;
        }

        public RestStatus status() {
            if (this.getMergedComponentState().size() != 0) {
                return RestStatus.OK;
            }
            return RestStatus.NOT_FOUND;
        }

        public Health getHealth() {
            this.initMergedComponentState();
            return this.health;
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        private String moduleId;
        private boolean verbose;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.moduleId = in.readOptionalString();
            this.verbose = in.readBoolean();
        }

        public NodeRequest(Request request) {
            this.moduleId = request.getModuleId();
            this.verbose = request.isVerbose();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.moduleId);
            out.writeBoolean(this.verbose);
        }
    }

    public static class Request
    extends BaseNodesRequest {
        private String moduleId;
        private boolean verbose;

        public Request(String moduleId) {
            super(new String[0]);
            this.moduleId = moduleId;
        }

        public Request(String moduleId, boolean verbose) {
            super(new String[0]);
            this.moduleId = moduleId;
            this.verbose = verbose;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }
}

