/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    default public ThrowingFunction<Void, T, E> asFunction() {
        return arg -> this.get();
    }

    public static <T> Supplier<T> unchecked(ThrowingSupplier<T, ?> supplier) {
        return Objects.requireNonNull(supplier).uncheck();
    }

    public static <T> Supplier<Optional<T>> lifted(ThrowingSupplier<T, ?> supplier) {
        return Objects.requireNonNull(supplier).lift();
    }

    public static <T1> Supplier<T1> sneaky(ThrowingSupplier<T1, ?> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    default public Supplier<T> uncheck() {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }

    default public Supplier<Optional<T>> lift() {
        return () -> {
            try {
                return Optional.ofNullable(this.get());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }
}

