/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import java.io.IOException;

public class ModDetectionCodePacket
extends ContainedPacket {
    private byte[] digest;

    ModDetectionCodePacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    ModDetectionCodePacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(19, newPacketFormat);
        this.digest = new byte[20];
        in.readFully(this.digest);
    }

    public ModDetectionCodePacket(byte[] digest) throws IOException {
        super(19);
        this.digest = new byte[digest.length];
        System.arraycopy(digest, 0, this.digest, 0, this.digest.length);
    }

    public byte[] getDigest() {
        byte[] tmp = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, tmp, 0, tmp.length);
        return tmp;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.hasNewPacketFormat(), 19, this.digest);
    }
}

