/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import com.floragunn.searchguard.lpg.FingerprintUtil;
import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.Streams;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OnePassSignaturePacket
extends ContainedPacket {
    public static final int VERSION_3 = 3;
    public static final int VERSION_6 = 6;
    private final int version;
    private final int sigType;
    private final int hashAlgorithm;
    private final int keyAlgorithm;
    private final long keyID;
    private final byte[] fingerprint;
    private final byte[] salt;
    private final int isContaining;

    OnePassSignaturePacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    OnePassSignaturePacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(4, newPacketFormat);
        this.version = in.read();
        this.sigType = in.read();
        this.hashAlgorithm = in.read();
        this.keyAlgorithm = in.read();
        if (this.version == 3) {
            this.keyID = StreamUtil.readKeyID(in);
            this.fingerprint = null;
            this.salt = null;
        } else if (this.version == 6) {
            int saltLen = in.read();
            if (saltLen < 0) {
                throw new IOException("Version 6 OPS packet has invalid salt length.");
            }
            this.salt = new byte[saltLen];
            in.readFully(this.salt);
            this.fingerprint = new byte[32];
            in.readFully(this.fingerprint);
            this.keyID = FingerprintUtil.keyIdFromV6Fingerprint(this.fingerprint);
        } else {
            Streams.drain(in);
            throw new UnsupportedPacketVersionException("Unsupported OnePassSignature packet version encountered: " + this.version);
        }
        this.isContaining = in.read();
    }

    public OnePassSignaturePacket(int sigType, int hashAlgorithm, int keyAlgorithm, long keyID, boolean isNested) {
        super(4);
        this.version = 3;
        this.sigType = sigType;
        this.hashAlgorithm = hashAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.keyID = keyID;
        this.fingerprint = null;
        this.salt = null;
        this.isContaining = isNested ? 0 : 1;
    }

    public OnePassSignaturePacket(int sigType, int hashAlgorithm, int keyAlgorithm, byte[] salt, byte[] fingerprint, boolean isNested) {
        super(4);
        this.version = 6;
        this.sigType = sigType;
        this.hashAlgorithm = hashAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.salt = salt;
        this.fingerprint = fingerprint;
        this.isContaining = isNested ? 0 : 1;
        this.keyID = FingerprintUtil.keyIdFromV6Fingerprint(fingerprint);
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.sigType;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }

    public boolean isContaining() {
        return this.isContaining == 1;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write(this.sigType);
        pOut.write(this.hashAlgorithm);
        pOut.write(this.keyAlgorithm);
        if (this.version == 3) {
            StreamUtil.writeKeyID(pOut, this.keyID);
        } else if (this.version == 6) {
            pOut.write(this.salt.length);
            pOut.write(this.salt);
            pOut.write(this.fingerprint);
        }
        pOut.write(this.isContaining);
        pOut.close();
        out.writePacket(this.hasNewPacketFormat(), 4, bOut.toByteArray());
    }
}

