/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.SignatureSubpacket;
import com.floragunn.searchguard.lpg.SignatureSubpacketTags;
import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.Streams;
import com.floragunn.searchguard.lpg.sig.EmbeddedSignature;
import com.floragunn.searchguard.lpg.sig.Exportable;
import com.floragunn.searchguard.lpg.sig.Features;
import com.floragunn.searchguard.lpg.sig.IntendedRecipientFingerprint;
import com.floragunn.searchguard.lpg.sig.IssuerFingerprint;
import com.floragunn.searchguard.lpg.sig.IssuerKeyID;
import com.floragunn.searchguard.lpg.sig.KeyExpirationTime;
import com.floragunn.searchguard.lpg.sig.KeyFlags;
import com.floragunn.searchguard.lpg.sig.LibrePGPPreferredEncryptionModes;
import com.floragunn.searchguard.lpg.sig.NotationData;
import com.floragunn.searchguard.lpg.sig.PolicyURI;
import com.floragunn.searchguard.lpg.sig.PreferredAEADCiphersuites;
import com.floragunn.searchguard.lpg.sig.PreferredAlgorithms;
import com.floragunn.searchguard.lpg.sig.PreferredKeyServer;
import com.floragunn.searchguard.lpg.sig.PrimaryUserID;
import com.floragunn.searchguard.lpg.sig.RegularExpression;
import com.floragunn.searchguard.lpg.sig.Revocable;
import com.floragunn.searchguard.lpg.sig.RevocationKey;
import com.floragunn.searchguard.lpg.sig.RevocationReason;
import com.floragunn.searchguard.lpg.sig.SignatureCreationTime;
import com.floragunn.searchguard.lpg.sig.SignatureExpirationTime;
import com.floragunn.searchguard.lpg.sig.SignatureTarget;
import com.floragunn.searchguard.lpg.sig.SignerUserID;
import com.floragunn.searchguard.lpg.sig.TrustSignature;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    private final InputStream in;
    private final int limit;

    public SignatureSubpacketInputStream(InputStream in) {
        this(in, StreamUtil.findLimit(in));
    }

    public SignatureSubpacketInputStream(InputStream in, int limit) {
        this.in = in;
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        boolean[] flags = new boolean[3];
        int bodyLen = StreamUtil.readBodyLen(this, flags);
        if (flags[StreamUtil.flag_eof]) {
            return null;
        }
        if (flags[StreamUtil.flag_partial]) {
            throw new IOException("unexpected length header");
        }
        boolean isLongLength = flags[StreamUtil.flag_isLongLength];
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        if (bodyLen <= 0 || bodyLen > this.limit && bodyLen > 2048) {
            throw new EOFException("out of range data found in signature sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        int bytesRead = Streams.readFully(this.in, data);
        boolean isCritical = (tag & 0x80) != 0;
        int type = tag & 0x7F;
        if (bytesRead != data.length) {
            switch (type) {
                case 2: {
                    data = this.checkData(data, 4, bytesRead, "Signature Creation Time");
                    break;
                }
                case 16: {
                    data = this.checkData(data, 8, bytesRead, "Issuer");
                    break;
                }
                case 9: {
                    data = this.checkData(data, 4, bytesRead, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    data = this.checkData(data, 4, bytesRead, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        switch (type) {
            case 2: {
                return new SignatureCreationTime(isCritical, isLongLength, data);
            }
            case 32: {
                return new EmbeddedSignature(isCritical, isLongLength, data);
            }
            case 9: {
                return new KeyExpirationTime(isCritical, isLongLength, data);
            }
            case 3: {
                return new SignatureExpirationTime(isCritical, isLongLength, data);
            }
            case 7: {
                return new Revocable(isCritical, isLongLength, data);
            }
            case 4: {
                return new Exportable(isCritical, isLongLength, data);
            }
            case 30: {
                return new Features(isCritical, isLongLength, data);
            }
            case 16: {
                return new IssuerKeyID(isCritical, isLongLength, data);
            }
            case 5: {
                return new TrustSignature(isCritical, isLongLength, data);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(type, isCritical, isLongLength, data);
            }
            case 34: {
                return new LibrePGPPreferredEncryptionModes(isCritical, isLongLength, data);
            }
            case 39: {
                return new PreferredAEADCiphersuites(isCritical, isLongLength, data);
            }
            case 24: {
                return new PreferredKeyServer(isCritical, isLongLength, data);
            }
            case 27: {
                return new KeyFlags(isCritical, isLongLength, data);
            }
            case 26: {
                return new PolicyURI(isCritical, isLongLength, data);
            }
            case 25: {
                return new PrimaryUserID(isCritical, isLongLength, data);
            }
            case 28: {
                return new SignerUserID(isCritical, isLongLength, data);
            }
            case 20: {
                return new NotationData(isCritical, isLongLength, data);
            }
            case 6: {
                return new RegularExpression(isCritical, isLongLength, data);
            }
            case 29: {
                return new RevocationReason(isCritical, isLongLength, data);
            }
            case 12: {
                return new RevocationKey(isCritical, isLongLength, data);
            }
            case 31: {
                return new SignatureTarget(isCritical, isLongLength, data);
            }
            case 33: {
                return new IssuerFingerprint(isCritical, isLongLength, data);
            }
            case 35: {
                return new IntendedRecipientFingerprint(isCritical, isLongLength, data);
            }
        }
        return new SignatureSubpacket(type, isCritical, isLongLength, data);
    }

    private byte[] checkData(byte[] data, int expected, int bytesRead, String name) throws EOFException {
        if (bytesRead != expected) {
            throw new EOFException("truncated " + name + " subpacket data.");
        }
        return Arrays.copyOfRange(data, 0, expected);
    }
}

