/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.LiteralDataPacket;
import com.floragunn.searchguard.lpg.Packet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class PGPLiteralData {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final char MIME = 'm';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = new Date(0L);
    LiteralDataPacket data;

    public PGPLiteralData(BCPGInputStream pIn) throws IOException {
        Packet packet = pIn.readPacket();
        if (!(packet instanceof LiteralDataPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (LiteralDataPacket)packet;
    }

    public int getFormat() {
        return this.data.getFormat();
    }

    public String getFileName() {
        return this.data.getFileName();
    }

    public byte[] getRawFileName() {
        return this.data.getRawFileName();
    }

    public Date getModificationTime() {
        return new Date(this.data.getModificationTime());
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public InputStream getDataStream() {
        return this.getInputStream();
    }
}

