/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.sig;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.FingerprintUtil;
import com.floragunn.searchguard.lpg.KeyIdentifier;
import com.floragunn.searchguard.lpg.SignatureSubpacket;

public class IssuerFingerprint
extends SignatureSubpacket {
    public IssuerFingerprint(boolean critical, boolean isLongLength, byte[] data) {
        super(33, critical, isLongLength, data);
    }

    public IssuerFingerprint(boolean critical, int keyVersion, byte[] fingerprint) {
        super(33, critical, false, Arrays.prepend(fingerprint, (byte)keyVersion));
    }

    public int getKeyVersion() {
        return this.data[0] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange(this.data, 1, this.data.length);
    }

    public long getKeyID() {
        if (this.getKeyVersion() == 4) {
            return FingerprintUtil.keyIdFromV4Fingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 5) {
            return FingerprintUtil.keyIdFromLibrePgpFingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 6) {
            return FingerprintUtil.keyIdFromV6Fingerprint(this.getFingerprint());
        }
        return 0L;
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint());
    }
}

