/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import java.util.Objects;

class AddMigrationMarkerToGlobalTenantIndexStep
implements MigrationStep {
    private final IndexSettingsManager indexSettingsManager;

    public AddMigrationMarkerToGlobalTenantIndexStep(IndexSettingsManager indexSettingsManager) {
        this.indexSettingsManager = Objects.requireNonNull(indexSettingsManager, "Index settings manager is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        String indexName = context.getGlobalTenantIndexName();
        if (this.indexSettingsManager.isMigrationMarkerPresent(indexName)) {
            return new StepResult(StepExecutionStatus.OK, "Migration marker already present in index '" + indexName + "'");
        }
        this.indexSettingsManager.addMigrationMarker(indexName);
        return new StepResult(StepExecutionStatus.OK, "Migration marker added to index", "Migration marker added to index '" + indexName + "'");
    }

    @Override
    public String name() {
        return "Add migration marker to global tenant index";
    }
}

