/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.support;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.script.SignalsScriptContextFactory;
import com.floragunn.signals.support.ScriptExecutionError;
import com.floragunn.signals.support.ScriptValidationError;
import com.google.common.base.Functions;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InlineMustacheTemplate<ResultType>
implements ToXContent {
    private static final Logger log = LogManager.getLogger(InlineMustacheTemplate.class);
    private String source;
    private ResultType parsedConstantValue;
    private boolean constant = false;
    private ValidatingFunction<String, ResultType> conversionFunction;
    private TemplateScript.Factory factory;
    private Object expectedValue;

    private InlineMustacheTemplate(String source, ValidatingFunction<String, ResultType> conversionFunction, Object expectedValue) {
        this.source = source;
        this.conversionFunction = conversionFunction;
        this.expectedValue = expectedValue;
    }

    private InlineMustacheTemplate(ResultType constant) {
        this.parsedConstantValue = constant;
        this.constant = true;
    }

    private void compile(ScriptService scriptService, ValidationErrors validationErrors) {
        if (this.source == null || !this.source.contains("{{")) {
            this.constant = true;
            try {
                this.parsedConstantValue = this.conversionFunction.apply((Object)this.source);
            }
            catch (Exception e) {
                validationErrors.add(new InvalidAttributeValue(null, (Object)this.source, this.expectedValue).cause((Throwable)e));
            }
            return;
        }
        Script script = new Script(ScriptType.INLINE, "mustache", this.source, Collections.emptyMap());
        try {
            this.factory = (TemplateScript.Factory)scriptService.compile(script, SignalsScriptContextFactory.TEMPLATE_CONTEXT);
        }
        catch (ScriptException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while compiling script " + String.valueOf(script), (Throwable)e);
            }
            validationErrors.add((ValidationError)new ScriptValidationError(null, e));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.constant) {
            builder.value(String.valueOf(this.parsedConstantValue));
        } else {
            builder.value(this.source);
        }
        return builder;
    }

    public TemplateScript.Factory getFactory() {
        return this.factory;
    }

    public String render(Map<String, Object> params) throws ScriptException {
        if (this.factory != null) {
            return this.factory.newInstance(params).execute();
        }
        if (this.constant) {
            return this.source;
        }
        return null;
    }

    public ResultType get(Map<String, Object> params) throws ConfigValidationException {
        if (this.constant) {
            return this.parsedConstantValue;
        }
        String value = null;
        try {
            value = this.render(params);
        }
        catch (ScriptException e) {
            throw new ConfigValidationException((ValidationError)new ScriptExecutionError(null, e));
        }
        if (value != null) {
            try {
                return (ResultType)this.conversionFunction.apply((Object)value);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)value, this.expectedValue));
            }
            catch (Exception e) {
                throw new ConfigValidationException(new ValidationError(null, value));
            }
        }
        return null;
    }

    public ResultType get(Map<String, Object> params, String attribute, ValidationErrors validationErrors) {
        try {
            return this.get(params);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(attribute, e);
            return null;
        }
    }

    public boolean isConstant() {
        return this.constant;
    }

    public ResultType getConstant() {
        return this.parsedConstantValue;
    }

    public static <ResultType> InlineMustacheTemplate<ResultType> parse(ScriptService scriptService, String value, Function<String, ResultType> conversionFunction) throws ConfigValidationException {
        return InlineMustacheTemplate.parse(scriptService, value, conversionFunction, null);
    }

    public static <ResultType> InlineMustacheTemplate<ResultType> parse(ScriptService scriptService, String value, Function<String, ResultType> conversionFunction, Object expectedValue) throws ConfigValidationException {
        return InlineMustacheTemplate.parse(scriptService, value, ValidatingFunction.from(conversionFunction), expectedValue);
    }

    public static <ResultType> InlineMustacheTemplate<ResultType> parse(ScriptService scriptService, String value, ValidatingFunction<String, ResultType> conversionFunction) throws ConfigValidationException {
        return InlineMustacheTemplate.parse(scriptService, value, conversionFunction, null);
    }

    public static <ResultType> InlineMustacheTemplate<ResultType> parse(ScriptService scriptService, String value, ValidatingFunction<String, ResultType> conversionFunction, Object expectedValue) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        InlineMustacheTemplate<ResultType> result = new InlineMustacheTemplate<ResultType>(value, conversionFunction, expectedValue);
        result.compile(scriptService, validationErrors);
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public static InlineMustacheTemplate<String> parse(ScriptService scriptService, String value) throws ConfigValidationException {
        return InlineMustacheTemplate.parse(scriptService, value, Functions.identity());
    }

    public static <ResultType> InlineMustacheTemplate<ResultType> constant(ResultType value) {
        return value != null ? new InlineMustacheTemplate<ResultType>(value) : null;
    }
}

