/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValidationErrors
implements Document<ValidationErrors> {
    private Multimap<String, ValidationError> attributeToErrorMap;
    private ValidationErrors parent;
    private String attributeInParent;

    public ValidationErrors() {
        this.attributeToErrorMap = LinkedListMultimap.create();
    }

    public ValidationErrors(ValidationErrors parent, String attributeInParent) {
        this.attributeToErrorMap = LinkedListMultimap.create();
        this.parent = parent;
        this.attributeInParent = attributeInParent;
    }

    public ValidationErrors(Multimap<String, ValidationError> multimap) {
        this.attributeToErrorMap = multimap;
    }

    public ValidationErrors(ValidationError singleValidationError) {
        this.attributeToErrorMap = ImmutableListMultimap.of((Object)singleValidationError.getAttribute(), (Object)singleValidationError);
    }

    public void throwExceptionForPresentErrors() throws ConfigValidationException {
        if (this.hasErrors()) {
            throw new ConfigValidationException(this);
        }
    }

    public boolean hasErrors() {
        return this.attributeToErrorMap.size() > 0;
    }

    public ValidationErrors add(ValidationError validationError) {
        this.attributeToErrorMap.put((Object)validationError.getAttribute(), (Object)validationError);
        if (this.parent != null) {
            this.parent.add(this.attributeInParent, new ValidationErrors(validationError));
        }
        return this;
    }

    public ValidationErrors add(Collection<ValidationError> validationErrors) {
        for (ValidationError validationError : validationErrors) {
            this.add(validationError);
        }
        return this;
    }

    public ValidationErrors add(String attribute, ValidationResult<?> validationResult) {
        return this.add(attribute, validationResult.getValidationErrors());
    }

    public ValidationErrors add(String attribute, ValidationErrors validationErrors) {
        for (Map.Entry entry : validationErrors.attributeToErrorMap.entries()) {
            String subAttribute = attribute != null && !"_".equals(attribute) ? (entry.getKey() != null && !"_".equals(entry.getKey()) ? (((String)entry.getKey()).startsWith("[") ? attribute + (String)entry.getKey() : attribute + "." + (String)entry.getKey()) : attribute) : (entry.getKey() != null && !"_".equals(entry.getKey()) ? (String)entry.getKey() : "_");
            this.attributeToErrorMap.put((Object)subAttribute, (Object)((ValidationError)entry.getValue()));
        }
        if (this.parent != null) {
            this.parent.add(attribute == null ? this.attributeInParent : attribute + "." + this.attributeInParent, validationErrors);
        }
        return this;
    }

    public ValidationErrors add(String attribute, ConfigValidationException watchValidationException) {
        this.add(attribute, watchValidationException.getValidationErrors());
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : this.attributeToErrorMap.entries()) {
            result.append((String)entry.getKey()).append(":\n\t").append(((ValidationError)entry.getValue()).toValidationErrorsOverviewString());
            result.append("\n");
        }
        return result.toString();
    }

    public Map<String, Collection<ValidationError>> getErrors() {
        return this.attributeToErrorMap.asMap();
    }

    public String toDebugString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : this.attributeToErrorMap.entries()) {
            result.append((String)entry.getKey()).append(":\n\t").append(((ValidationError)entry.getValue()).toValidationErrorsOverviewString());
            result.append("\n");
            if (((ValidationError)entry.getValue()).getCause() == null) continue;
            StringWriter stringWriter = new StringWriter();
            ((ValidationError)entry.getValue()).getCause().printStackTrace(new PrintWriter(stringWriter));
            result.append(stringWriter.toString()).append("\n");
        }
        return result.toString();
    }

    public int size() {
        return this.attributeToErrorMap.size();
    }

    public ValidationError getOnlyValidationError() {
        if (this.attributeToErrorMap.size() == 1) {
            ValidationError result = (ValidationError)this.attributeToErrorMap.values().iterator().next();
            result.setAttribute((String)this.attributeToErrorMap.keys().iterator().next());
            return result;
        }
        return null;
    }

    public Throwable getCause() {
        for (ValidationError validationError : this.attributeToErrorMap.values()) {
            if (validationError.getCause() == null) continue;
            return validationError.getCause();
        }
        return null;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : this.attributeToErrorMap.asMap().entrySet()) {
            result.put(entry.getKey() != null ? (String)entry.getKey() : "_", ((Collection)entry.getValue()).stream().map(ValidationError::toBasicObject).collect(Collectors.toList()));
        }
        return result;
    }

    public ValidationErrors mapKeys(Map<String, String> oldToNewKeyMap) {
        if (oldToNewKeyMap.size() == 0 || this.attributeToErrorMap.size() == 0) {
            return this;
        }
        LinkedListMultimap newErrorMap = LinkedListMultimap.create((int)this.attributeToErrorMap.size());
        for (Map.Entry entry : this.attributeToErrorMap.asMap().entrySet()) {
            newErrorMap.putAll((Object)this.mapKey((String)entry.getKey(), oldToNewKeyMap), (Iterable)entry.getValue());
        }
        return new ValidationErrors((Multimap<String, ValidationError>)newErrorMap);
    }

    public Map<String, ValidationErrors> groupByKeys(Map<String, String> oldToNewKeyMap) {
        if (this.attributeToErrorMap.size() == 0) {
            return Collections.emptyMap();
        }
        if (oldToNewKeyMap.size() == 0) {
            return Collections.singletonMap("", this);
        }
        LinkedHashMap<String, ValidationErrors> result = new LinkedHashMap<String, ValidationErrors>(oldToNewKeyMap.size() + 5);
        for (Map.Entry entry : this.attributeToErrorMap.asMap().entrySet()) {
            SplitKey splitKey = this.splitAndMapKey((String)entry.getKey(), oldToNewKeyMap);
            ValidationErrors group = result.computeIfAbsent(splitKey.group, k -> new ValidationErrors());
            group.attributeToErrorMap.putAll((Object)splitKey.key, (Iterable)entry.getValue());
        }
        return result;
    }

    private String mapKey(String key, Map<String, String> oldToNewKeyMap) {
        String newKey = oldToNewKeyMap.get(key);
        if (newKey != null) {
            return newKey;
        }
        for (Map.Entry<String, String> entry : oldToNewKeyMap.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue() + key.substring(entry.getKey().length());
        }
        return key;
    }

    private SplitKey splitAndMapKey(String key, Map<String, String> oldToNewKeyMap) {
        String newKey = oldToNewKeyMap.get(key);
        if (newKey != null) {
            return new SplitKey(newKey, "");
        }
        for (Map.Entry<String, String> entry : oldToNewKeyMap.entrySet()) {
            if (!key.startsWith(entry.getKey()) || key.charAt(entry.getKey().length()) != '.') continue;
            return new SplitKey(entry.getValue(), key.substring(entry.getKey().length() + 1));
        }
        return new SplitKey("", key);
    }

    public static ValidationErrors parse(Map<String, Object> document) {
        ValidationErrors result = new ValidationErrors();
        for (Map.Entry<String, Object> entry : document.entrySet()) {
            result.add(ValidationError.parseArray(entry.getKey(), DocNode.wrap(entry.getValue())));
        }
        return result;
    }

    @Override
    public Object toBasicObject() {
        return this.toMap();
    }

    private static class SplitKey {
        final String group;
        final String key;

        public SplitKey(String group, String key) {
            this.group = group;
            this.key = key;
        }
    }
}

