/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FeMultiTenancyConfigurationProvider
implements MultiTenancyConfigurationProvider {
    private final FeMultiTenancyModule module;

    public FeMultiTenancyConfigurationProvider(FeMultiTenancyModule module) {
        this.module = Objects.requireNonNull(module, "Front-end multi-tenancy module is required");
    }

    public Optional<FeMultiTenancyConfig> getConfig() {
        return Optional.ofNullable(this.module.getConfig());
    }

    public ImmutableSet<String> getTenantNames() {
        return this.module.getTenantNames();
    }

    public boolean isMultiTenancyEnabled() {
        return this.getConfig().map(FeMultiTenancyConfig::isEnabled).orElse(this.module.isEnabled());
    }

    public String getKibanaServerUser() {
        return this.getConfig().map(FeMultiTenancyConfig::getServerUsername).orElse("kibanaserver");
    }

    public String getKibanaIndex() {
        return this.getConfig().map(FeMultiTenancyConfig::getIndex).orElse(".kibana");
    }

    public TenantAccessMapper getTenantAccessMapper() {
        return this.module.getTenantAccessMapper();
    }

    public boolean isGlobalTenantEnabled() {
        return this.getConfig().map(FeMultiTenancyConfig::isGlobalTenantEnabled).orElse(true);
    }

    public boolean isPrivateTenantEnabled() {
        return this.getConfig().map(FeMultiTenancyConfig::isPrivateTenantEnabled).orElse(false);
    }

    public List<String> getPreferredTenants() {
        return this.getConfig().map(FeMultiTenancyConfig::getPreferredTenants).orElse(Collections.emptyList());
    }
}

