/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authtoken.AuthTokenAuthenticationDomain;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.AuthTokenServiceConfig;
import com.floragunn.searchguard.authtoken.AuthTokenServiceConfigApi;
import com.floragunn.searchguard.authtoken.api.AuthTokenInfoAction;
import com.floragunn.searchguard.authtoken.api.AuthTokenInfoRestAction;
import com.floragunn.searchguard.authtoken.api.AuthTokenRestAction;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.GetAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokenRestAction;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokensAction;
import com.floragunn.searchguard.authtoken.api.TransportAuthTokenInfoAction;
import com.floragunn.searchguard.authtoken.api.TransportCreateAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.TransportGetAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.TransportRevokeAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.TransportSearchAuthTokensAction;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateAction;
import com.floragunn.searchguard.authtoken.update.TransportPushAuthTokenUpdateAction;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProvider;
import com.floragunn.searchguard.sgconf.history.ConfigHistoryService;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.action.ActionHandlerFactory;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;

public class AuthTokenModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(AuthTokenModule.class);
    private AuthTokenService authTokenService;
    private ConfigVarService configVarService;
    private final ComponentState componentState = new ComponentState(1000, null, "auth_token_service", AuthTokenModule.class).requiresEnterpriseLicense();
    private AuthTokenAuthenticationDomain authenticationDomain;

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{new AuthTokenRestAction(), new SearchAuthTokenRestAction(clusterSupportsFeature), new AuthTokenInfoRestAction(), AuthTokenServiceConfigApi.REST_API});
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return ImmutableList.of((Object)ActionHandlerFactory.actionHandler((ActionType)CreateAuthTokenAction.INSTANCE, TransportCreateAuthTokenAction.class), (Object)ActionHandlerFactory.actionHandler((ActionType)PushAuthTokenUpdateAction.INSTANCE, TransportPushAuthTokenUpdateAction.class), (Object)ActionHandlerFactory.actionHandler((ActionType)GetAuthTokenAction.INSTANCE, TransportGetAuthTokenAction.class), (Object[])new ActionPlugin.ActionHandler[]{ActionHandlerFactory.actionHandler((ActionType)RevokeAuthTokenAction.INSTANCE, TransportRevokeAuthTokenAction.class), ActionHandlerFactory.actionHandler((ActionType)SearchAuthTokensAction.INSTANCE, TransportSearchAuthTokensAction.class), ActionHandlerFactory.actionHandler((ActionType)AuthTokenInfoAction.INSTANCE, TransportAuthTokenInfoAction.class)}).with(AuthTokenServiceConfigApi.ACTION_HANDLERS);
    }

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        this.configVarService = baseDependencies.getConfigVarService();
        this.configVarService.requestRandomKey("auth_tokens_signing_key_hs512", 512, "authc");
        PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)baseDependencies.getLocalClient());
        ConfigHistoryService configHistoryService = new ConfigHistoryService(baseDependencies.getConfigurationRepository(), baseDependencies.getStaticSgConfig(), privilegedConfigClient, baseDependencies.getProtectedConfigIndexService(), baseDependencies.getActions(), baseDependencies.getStaticSettings(), baseDependencies.getPrivilegesEvaluator());
        this.componentState.addPart(configHistoryService.getComponentState());
        this.authTokenService = new AuthTokenService(privilegedConfigClient, baseDependencies.getAuthorizationService(), baseDependencies.getPrivilegesEvaluator(), configHistoryService, baseDependencies.getStaticSettings(), baseDependencies.getThreadPool(), baseDependencies.getClusterService(), baseDependencies.getProtectedConfigIndexService(), baseDependencies.getActions(), null, this.componentState);
        AuthTokenAuthenticationDomain authenticationBackend = new AuthTokenAuthenticationDomain(this.authTokenService);
        baseDependencies.getSpecialPrivilegesEvaluationContextProviderRegistry().add((SpecialPrivilegesEvaluationContextProvider)this.authTokenService);
        this.authenticationDomain = new AuthTokenAuthenticationDomain(this.authTokenService);
        ConfigurationRepository configurationRepository = baseDependencies.getConfigurationRepository();
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration config = configMap.get(AuthTokenServiceConfig.TYPE);
                if (config != null && config.getCEntry("default") != null) {
                    AuthTokenModule.this.authTokenService.setConfig((AuthTokenServiceConfig)config.getCEntry("default"));
                    AuthTokenModule.this.componentState.setConfigVersion(config.getDocVersion());
                    AuthTokenModule.this.componentState.setState(ComponentState.State.INITIALIZED, "using_config");
                } else {
                    AuthTokenModule.this.componentState.setState(ComponentState.State.SUSPENDED, "not_configured");
                }
            }
        });
        return Arrays.asList(this.authTokenService, configHistoryService, authenticationBackend);
    }

    public StaticSettings.AttributeSet getSettings() {
        return StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{AuthTokenService.INDEX_NAME, AuthTokenService.CLEANUP_INTERVAL, ConfigHistoryService.CACHE_MAX_SIZE, ConfigHistoryService.CACHE_TTL, ConfigHistoryService.INDEX_NAME, ConfigHistoryService.MODEL_CACHE_MAX_SIZE, ConfigHistoryService.MODEL_CACHE_TTL});
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public List<AuthenticationDomain<HttpAuthenticationFrontend>> getImplicitHttpAuthenticationDomains() {
        return Collections.singletonList(this.authenticationDomain);
    }

    public ImmutableSet<String> getCapabilities() {
        return ImmutableSet.of((Object)"auth_tokens");
    }
}

