/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.internal_users_db;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.RedactableDocument;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.configuration.Hideable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

public class InternalUser
implements PatchableDocument<InternalUser>,
RedactableDocument,
Hideable {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final Map<String, Object> rawDocument;
    private final String description;
    private final String passwordHash;
    private final boolean reserved;
    private final boolean hidden;
    private final ImmutableSet<String> backendRoles;
    private final ImmutableSet<String> searchGuardRoles;
    private final ImmutableMap<String, Object> attributes;

    private InternalUser(Map<String, Object> rawDocument, String description, String passwordHash, boolean reserved, boolean hidden, List<String> backendRoles, List<String> searchGuardRoles, Map<String, Object> attributes) {
        this.rawDocument = rawDocument;
        this.description = description;
        this.passwordHash = passwordHash;
        this.reserved = reserved;
        this.hidden = hidden;
        this.backendRoles = ImmutableSet.of(backendRoles);
        this.searchGuardRoles = ImmutableSet.of(searchGuardRoles);
        this.attributes = ImmutableMap.of(attributes);
    }

    public Object toBasicObject() {
        if (this.rawDocument != null) {
            return this.rawDocument;
        }
        return ImmutableMap.of((Object)"description", (Object)this.description, (Object)"hash", (Object)this.passwordHash, (Object)"backend_roles", this.backendRoles, (Object)"search_guard_roles", this.searchGuardRoles, (Object)"attributes", this.attributes);
    }

    public ImmutableMap<String, Object> toRedactedBasicObject() {
        if (this.rawDocument != null) {
            return ImmutableMap.without(this.rawDocument, (Object)"hash");
        }
        return ImmutableMap.ofNonNull((Object)"description", (Object)this.description, (Object)"backend_roles", this.backendRoles, (Object)"search_guard_roles", this.searchGuardRoles, (Object)"attributes", this.attributes);
    }

    public String getDescription() {
        return this.description;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public ImmutableSet<String> getBackendRoles() {
        return this.backendRoles;
    }

    public ImmutableSet<String> getSearchGuardRoles() {
        return this.searchGuardRoles;
    }

    public ImmutableMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public static ValidationResult<InternalUser> parse(Object parsedJson, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(DocNode.wrap((Object)parsedJson), validationErrors, context);
        String description = vNode.get("description").asString();
        String passwordHash = null;
        if (vNode.hasNonNull("password")) {
            if (vNode.get("password").asString().length() == 0) {
                validationErrors.add((ValidationError)new InvalidAttributeValue("password", (Object)"", (Object)"A non-empty password"));
            }
            passwordHash = InternalUser.hash(vNode.get("password").asString().trim().toCharArray());
        } else if (vNode.hasNonNull("hash")) {
            passwordHash = vNode.get("hash").asString();
        }
        boolean reserved = vNode.get("reserved").withDefault(false).asBoolean();
        boolean hidden = vNode.get("hidden").withDefault(false).asBoolean();
        ImmutableList backendRoles = vNode.get("backend_roles").asList().withEmptyListAsDefault().ofStrings();
        ImmutableList searchGuardRoles = vNode.get("search_guard_roles").asList().withEmptyListAsDefault().ofStrings();
        Object attributes = vNode.get("attributes").asMap();
        attributes = attributes != null ? Collections.unmodifiableMap(new LinkedHashMap(attributes)) : Collections.emptyMap();
        LinkedHashMap<String, Object> rawDocument = new LinkedHashMap<String, Object>((Map<String, Object>)DocNode.wrap((Object)parsedJson));
        rawDocument.remove("password");
        if (passwordHash != null) {
            rawDocument.put("hash", passwordHash);
        }
        if (validationErrors.hasErrors()) {
            return new ValidationResult(validationErrors);
        }
        return new ValidationResult((Object)new InternalUser(rawDocument, description, passwordHash, reserved, hidden, (List<String>)backendRoles, (List<String>)searchGuardRoles, (Map<String, Object>)attributes));
    }

    public static Document<InternalUser> check(Map<String, Object> parsedJson) throws ConfigValidationException {
        return Document.assertedType(parsedJson, InternalUser.class);
    }

    private static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        RANDOM.nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])clearTextPassword, (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    public InternalUser parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (InternalUser)InternalUser.parse(docNode.toMap(), context).get();
    }
}

