/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticationFrontend;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.rest.RestStatus;

public class RestImpersonationProcessor<AuthenticatorType extends AuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(RestImpersonationProcessor.class);
    private final User originalUser;
    private final Collection<AuthenticationDomain<AuthenticatorType>> authenticationDomains;
    private final Iterator<AuthenticationDomain<AuthenticatorType>> authenticationDomainIter;
    private final AdminDNs adminDns;
    private final Cache<String, User> impersonationCache;
    private final String impersonatedUserHeader;
    private boolean cacheResult = true;

    public RestImpersonationProcessor(User originalUser, String impersonatedUserHeader, Collection<AuthenticationDomain<AuthenticatorType>> authenticationDomains, AdminDNs adminDns, Cache<String, User> impersonationCache) {
        this.originalUser = originalUser;
        this.authenticationDomains = authenticationDomains;
        this.authenticationDomainIter = authenticationDomains.iterator();
        this.adminDns = adminDns;
        this.impersonationCache = impersonationCache;
        this.impersonatedUserHeader = impersonatedUserHeader;
        if (Strings.isNullOrEmpty((String)impersonatedUserHeader) || originalUser == null) {
            throw new IllegalStateException("impersonate() called with " + impersonatedUserHeader + "; " + String.valueOf(originalUser));
        }
    }

    public void impersonate(Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        try {
            User impersonatedUser;
            if (this.adminDns.isAdminDN(this.impersonatedUserHeader)) {
                throw new ElasticsearchSecurityException("It is not allowed to impersonate as an adminuser  '" + this.impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
            }
            if (!this.adminDns.isRestImpersonationAllowed(this.originalUser.getName(), this.impersonatedUserHeader)) {
                throw new ElasticsearchSecurityException("'" + this.originalUser.getName() + "' is not allowed to impersonate as '" + this.impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
            }
            if (this.impersonationCache != null && (impersonatedUser = (User)this.impersonationCache.getIfPresent((Object)this.impersonatedUserHeader)) != null) {
                impersonatedUser.setRequestedTenant(this.originalUser.getRequestedTenant());
                onResult.accept(AuthcResult.pass(impersonatedUser));
                return;
            }
            this.checkNextAuthenticationDomains(onResult, onFailure);
        }
        catch (Exception e) {
            onFailure.accept(e);
        }
    }

    private void checkNextAuthenticationDomains(Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        try {
            while (this.authenticationDomainIter.hasNext()) {
                AuthenticationDomain<AuthenticatorType> authenticationDomain = this.authenticationDomainIter.next();
                AuthDomainState state = this.checkCurrentAuthenticationDomain(authenticationDomain, onResult, onFailure);
                if (state == AuthDomainState.PENDING) {
                    return;
                }
                if (state != AuthDomainState.STOP) continue;
                onResult.accept(AuthcResult.STOP);
                return;
            }
            log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exist", (Object)this.originalUser.getName(), (Object)this.impersonatedUserHeader);
            throw new ElasticsearchSecurityException("No such user:" + this.impersonatedUserHeader, RestStatus.FORBIDDEN, new Object[0]);
        }
        catch (Exception e) {
            onFailure.accept(e);
            return;
        }
    }

    private AuthDomainState checkCurrentAuthenticationDomain(AuthenticationDomain<AuthenticatorType> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        try {
            AuthCredentials impersonatedUser;
            CompletableFuture<User> completedUserFuture;
            if (log.isDebugEnabled()) {
                log.debug("Checking authdomain " + String.valueOf(authenticationDomain) + " (total: " + this.authenticationDomains.size() + ")");
            }
            if ((completedUserFuture = authenticationDomain.impersonate(this.originalUser, impersonatedUser = AuthCredentials.forUser(this.impersonatedUserHeader).build())) != null) {
                completedUserFuture.whenComplete((completedUser, e) -> {
                    if (e != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Impersonation on " + String.valueOf(authenticationDomain) + " failed", e);
                        }
                        onFailure.accept((Exception)e);
                    } else if (completedUser != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Impersonation on " + String.valueOf(authenticationDomain) + " successful: " + String.valueOf(completedUser));
                        }
                        completedUser.setRequestedTenant(this.originalUser.getRequestedTenant());
                        if (this.cacheResult && this.impersonationCache != null) {
                            this.impersonationCache.put((Object)this.impersonatedUserHeader, completedUser);
                        }
                        onResult.accept(AuthcResult.pass(completedUser));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Impersonation on " + String.valueOf(authenticationDomain) + " did not find user information.");
                        }
                        this.checkNextAuthenticationDomains(onResult, onFailure);
                    }
                });
                return AuthDomainState.PENDING;
            }
            return AuthDomainState.SKIP;
        }
        catch (Exception e2) {
            log.error("Error while handling auth domain " + String.valueOf(authenticationDomain), (Throwable)e2);
            return AuthDomainState.SKIP;
        }
    }

    private static enum AuthDomainState {
        PENDING,
        SKIP,
        PASS,
        STOP;

    }
}

