/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.watch.common.ProxyTypeProvider;
import com.floragunn.signals.watch.common.ValidationLevel;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpProxyConfig
implements ToXContent {
    private static final Logger log = LogManager.getLogger(HttpProxyConfig.class);
    static final String PROXY_FIELD = "proxy";
    private String proxy;
    private Supplier<HttpHost> hostSupplier;
    private ProxyTypeProvider.Type type;

    private HttpProxyConfig() {
    }

    public static HttpProxyConfig create(ValidatingDocNode doc, HttpProxyHostRegistry httpProxyHostRegistry, ValidationLevel validationLevel) throws ConfigValidationException {
        HttpProxyConfig result = new HttpProxyConfig();
        result.init(doc, httpProxyHostRegistry, validationLevel);
        return result;
    }

    public static HttpProxyConfig create(String value) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        HttpProxyConfig result = new HttpProxyConfig();
        result.proxy = value;
        result.initWithoutUsingStoredProxy(validationErrors);
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public HttpHost getProxy() {
        return Optional.ofNullable(this.hostSupplier).map(Supplier::get).orElse(null);
    }

    public ProxyTypeProvider.Type getType() {
        return this.type;
    }

    public String toString() {
        return String.format("HttpProxyConfig [proxy=%s, type=%s]", new Object[]{this.proxy, this.type});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (ProxyTypeProvider.Type.USE_DEFAULT_PROXY == this.type) {
            builder.field(PROXY_FIELD, "default");
        } else if (ProxyTypeProvider.Type.USE_NO_PROXY == this.type) {
            builder.field(PROXY_FIELD, "none");
        } else if (this.proxy != null) {
            builder.field(PROXY_FIELD, this.proxy);
        } else {
            builder.field(PROXY_FIELD, "default");
        }
        return builder;
    }

    private void init(ValidatingDocNode doc, HttpProxyHostRegistry httpProxyHostRegistry, ValidationLevel validationLevel) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(doc, validationErrors);
        this.proxy = vJsonNode.get(PROXY_FIELD).asString();
        if (ProxyTypeProvider.determineTypeBasedOnValue(this.proxy) == ProxyTypeProvider.Type.USE_STORED_PROXY) {
            this.initUsingStoredProxy(validationErrors, httpProxyHostRegistry, validationLevel);
        } else {
            this.initWithoutUsingStoredProxy(validationErrors);
        }
        validationErrors.throwExceptionForPresentErrors();
    }

    private void initUsingStoredProxy(ValidationErrors validationErrors, HttpProxyHostRegistry httpProxyHostRegistry, ValidationLevel validationLevel) {
        Objects.requireNonNull(httpProxyHostRegistry, "HttpProxyHostRegistry is required");
        HttpProxyConfig.validateProxyIdIfStrictValidationIsRequired(this.proxy, httpProxyHostRegistry, validationLevel, validationErrors);
        this.hostSupplier = () -> httpProxyHostRegistry.findHttpProxyHost(this.proxy).orElseGet(() -> {
            log.warn("Watch uses not existing proxy with id '{}', connections will not be routed through proxy.", (Object)this.proxy);
            return null;
        });
        this.type = ProxyTypeProvider.Type.USE_STORED_PROXY;
    }

    private void initWithoutUsingStoredProxy(ValidationErrors validationErrors) {
        this.type = ProxyTypeProvider.determineTypeBasedOnValue(this.proxy);
        if (ProxyTypeProvider.Type.USE_DEFAULT_PROXY == this.type || ProxyTypeProvider.Type.USE_NO_PROXY == this.type) {
            this.hostSupplier = () -> null;
        } else if (ProxyTypeProvider.Type.USE_INLINE_PROXY == this.type) {
            try {
                HttpHost httpHost = HttpHost.create((String)this.proxy);
                this.hostSupplier = () -> httpHost;
            }
            catch (IllegalArgumentException e) {
                validationErrors.add(new InvalidAttributeValue(PROXY_FIELD, (Object)this.proxy, (Object)"URI or default or none").cause((Throwable)e));
            }
        } else {
            throw new IllegalArgumentException("Cannot initialize proxy of type: " + String.valueOf((Object)this.type) + " without using stored proxy");
        }
    }

    private static void validateProxyIdIfStrictValidationIsRequired(String proxyId, HttpProxyHostRegistry httpProxyHostRegistry, ValidationLevel validationLevel, ValidationErrors validationErrors) {
        Optional<HttpHost> httpProxyHostOptional;
        if (validationLevel.isStrictValidation() && !(httpProxyHostOptional = httpProxyHostRegistry.findHttpProxyHost(proxyId)).isPresent()) {
            validationErrors.add(PROXY_FIELD, new ValidationErrors(new ValidationError(null, "Http proxy '" + proxyId + "' not found.")));
        }
    }
}

