/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.meta.Meta;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class DlsFlsBaseContext {
    private final AuthInfoService authInfoService;
    private final AuthorizationService authorizationService;
    private final ThreadContext threadContext;
    private final Supplier<Meta> indexMetaDataSupplier;

    DlsFlsBaseContext(AuthInfoService authInfoService, AuthorizationService authorizationService, ThreadContext threadContext, Supplier<Meta> indexMetaDataSupplier) {
        this.authInfoService = authInfoService;
        this.authorizationService = authorizationService;
        this.threadContext = threadContext;
        this.indexMetaDataSupplier = indexMetaDataSupplier;
    }

    public PrivilegesEvaluationContext getPrivilegesEvaluationContext() {
        User user = this.authInfoService.peekCurrentUser();
        if (user == null) {
            return null;
        }
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.authInfoService.getSpecialPrivilegesEvaluationContext();
        ImmutableSet mappedRoles = this.authorizationService.getMappedRoles(user, specialPrivilegesEvaluationContext);
        return new PrivilegesEvaluationContext(user, this.authInfoService.isAdmin(user), mappedRoles, null, null, false, null, specialPrivilegesEvaluationContext);
    }

    public boolean isDlsDoneOnFilterLevel() {
        return this.threadContext.getHeader("_sg_filter_level_dls_done") != null;
    }

    String getDoneDlsFilterLevelQuery() {
        return this.threadContext.getHeader("_sg_filter_level_dls_done");
    }

    public Meta getIndexMetaData() {
        return this.indexMetaDataSupplier.get();
    }

    public boolean isInteralRequest() {
        return "true".equals(HeaderHelper.getSafeFromHeader((ThreadContext)this.threadContext, (String)"_sg_conf_request"));
    }
}

