/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsBaseContext;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.index.Index;

public class FlsQueryCacheWeightProvider
implements SearchGuardModule.QueryCacheWeightProvider,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(FlsQueryCacheWeightProvider.class);
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final DlsFlsBaseContext baseContext;
    private final ComponentState componentState = new ComponentState(12, null, "fls_query_cache_weight_provider", FlsQueryCacheWeightProvider.class).initialized();
    private final TimeAggregation applyAggregation = new TimeAggregation.Nanoseconds();

    FlsQueryCacheWeightProvider(DlsFlsBaseContext baseContext, AtomicReference<DlsFlsProcessedConfig> config) {
        this.config = config;
        this.baseContext = baseContext;
        this.componentState.addMetrics("apply", (Measurement)this.applyAggregation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Weight apply(Index index, Weight weight, QueryCachingPolicy policy) {
        DlsFlsProcessedConfig config = this.config.get();
        PrivilegesEvaluationContext context = this.baseContext.getPrivilegesEvaluationContext();
        if (context == null) {
            return null;
        }
        try (Meter meter = Meter.detail((MetricsLevel)config.getMetricsLevel(), (Measurement)this.applyAggregation);){
            Weight weight2;
            RoleBasedFieldAuthorization fieldAuthorization = config.getFieldAuthorization();
            RoleBasedFieldMasking fieldMasking = config.getFieldMasking();
            Meta.Index metaIndex = (Meta.Index)this.baseContext.getIndexMetaData().getIndexOrLike(index.getName());
            if (context.getSpecialPrivilegesEvaluationContext() != null && context.getSpecialPrivilegesEvaluationContext().getRolesConfig() != null) {
                SgDynamicConfiguration roles = context.getSpecialPrivilegesEvaluationContext().getRolesConfig();
                fieldAuthorization = new RoleBasedFieldAuthorization((SgDynamicConfiguration<Role>)roles, this.baseContext.getIndexMetaData(), MetricsLevel.NONE);
                fieldMasking = new RoleBasedFieldMasking((SgDynamicConfiguration<Role>)roles, fieldMasking.getFieldMaskingConfig(), this.baseContext.getIndexMetaData(), MetricsLevel.NONE);
            }
            if (fieldAuthorization.hasRestrictions(context, metaIndex, meter) || fieldMasking.hasRestrictions(context, metaIndex, meter)) {
                weight2 = weight;
                return weight2;
            }
            weight2 = null;
            return weight2;
        }
        catch (Exception e) {
            log.error("Error in FlsQueryCacheWeightProvider.apply() for index " + String.valueOf(index), (Throwable)e);
            this.componentState.addLastException("apply", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

