/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.DocumentWhitelist;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsBaseContext;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsLicenseInfo;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsFlsActionContext;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsFlsDirectoryReader;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;

public class DlsFlsDirectoryReaderWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    private static final Logger log = LogManager.getLogger(DlsFlsDirectoryReaderWrapper.class);
    private final IndexService indexService;
    private final AuditLog auditlog;
    private final Index index;
    private final ThreadContext threadContext;
    private final DlsFlsBaseContext dlsFlsBaseContext;
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final AtomicReference<DlsFlsLicenseInfo> licenseInfo;
    private final ComponentState componentState;
    private final TimeAggregation directoryReaderWrapperApplyAggregation;

    public DlsFlsDirectoryReaderWrapper(IndexService indexService, AuditLog auditlog, DlsFlsBaseContext dlsFlsBaseContext, AtomicReference<DlsFlsProcessedConfig> config, AtomicReference<DlsFlsLicenseInfo> licenseInfo, ComponentState directoryReaderWrapperComponentState, TimeAggregation directoryReaderWrapperApplyAggregation) {
        this.componentState = directoryReaderWrapperComponentState;
        this.directoryReaderWrapperApplyAggregation = directoryReaderWrapperApplyAggregation;
        this.indexService = indexService;
        this.index = indexService.index();
        this.auditlog = auditlog;
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.config = config;
        this.licenseInfo = licenseInfo;
        this.dlsFlsBaseContext = dlsFlsBaseContext;
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        DlsFlsDirectoryReader dlsFlsDirectoryReader;
        block14: {
            DlsFlsProcessedConfig config = this.config.get();
            PrivilegesEvaluationContext privilegesEvaluationContext = this.dlsFlsBaseContext.getPrivilegesEvaluationContext();
            if (privilegesEvaluationContext == null) {
                log.trace("DlsFlsDirectoryReaderWrapper.apply(): No PrivilegesEvaluationContext");
                return reader;
            }
            Meter meter = Meter.detail((MetricsLevel)config.getMetricsLevel(), (Measurement)this.directoryReaderWrapperApplyAggregation);
            try {
                ConstantScoreQuery dlsQuery;
                DlsFlsLicenseInfo licenseInfo = this.licenseInfo.get();
                ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
                RoleBasedDocumentAuthorization documentAuthorization = config.getDocumentAuthorization();
                RoleBasedFieldAuthorization fieldAuthorization = config.getFieldAuthorization();
                RoleBasedFieldMasking fieldMasking = config.getFieldMasking();
                DocumentWhitelist documentWhitelist = DocumentWhitelist.get((ThreadContext)this.threadContext);
                if (privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext() != null && privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig() != null) {
                    SgDynamicConfiguration roles = privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig();
                    documentAuthorization = new RoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roles, null, MetricsLevel.NONE);
                    fieldAuthorization = new RoleBasedFieldAuthorization((SgDynamicConfiguration<Role>)roles, null, MetricsLevel.NONE);
                    fieldMasking = new RoleBasedFieldMasking((SgDynamicConfiguration<Role>)roles, fieldMasking.getFieldMaskingConfig(), null, MetricsLevel.NONE);
                }
                Meta.Index metaIndex = (Meta.Index)this.dlsFlsBaseContext.getIndexMetaData().getIndexOrLike(this.index.getName());
                DlsRestriction dlsRestriction = !this.dlsFlsBaseContext.isDlsDoneOnFilterLevel() ? (DlsRestriction)documentAuthorization.getRestriction(privilegesEvaluationContext, metaIndex, meter) : DlsRestriction.NONE;
                RoleBasedFieldAuthorization.FlsRule flsRule = (RoleBasedFieldAuthorization.FlsRule)fieldAuthorization.getRestriction(privilegesEvaluationContext, metaIndex, meter);
                RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)fieldMasking.getRestriction(privilegesEvaluationContext, metaIndex, meter);
                if (dlsRestriction.isUnrestricted()) {
                    dlsQuery = null;
                } else {
                    SearchExecutionContext queryShardContext = this.indexService.newSearchExecutionContext(shardId.getId(), 0, null, this.nowSupplier(config), null, Collections.emptyMap());
                    dlsQuery = new ConstantScoreQuery(dlsRestriction.toQuery(queryShardContext, null));
                }
                if (!(!documentWhitelist.isWhitelistForIndexPresent(this.index.getName()) || flsRule.isAllowAll() && fieldMaskingRule.isAllowAll())) {
                    log.debug("Lifting FLS/FM for {} due to present document whitelist");
                    flsRule = RoleBasedFieldAuthorization.FlsRule.ALLOW_ALL;
                    fieldMaskingRule = RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Applying DLS/FLS:\nIndex: {}\ndlsRestriction: {}\ndlsQuery: {}\nfls: {}\nfieldMasking: {}", (Object)this.indexService.index().getName(), (Object)dlsRestriction, (Object)dlsQuery, (Object)flsRule, (Object)fieldMaskingRule);
                }
                DlsFlsActionContext dlsFlsContext = new DlsFlsActionContext((Query)dlsQuery, flsRule, fieldMaskingRule, this.indexService, this.threadContext, licenseInfo, this.auditlog, shardId);
                dlsFlsDirectoryReader = new DlsFlsDirectoryReader(reader, dlsFlsContext);
                if (meter == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (meter != null) {
                        try {
                            meter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrivilegesEvaluationException e) {
                    log.error("Error while evaluating privileges in " + String.valueOf(this), (Throwable)e);
                    this.componentState.addLastException("wrap_reader", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            meter.close();
        }
        return dlsFlsDirectoryReader;
    }

    private LongSupplier nowSupplier(DlsFlsProcessedConfig config) {
        if (config.getDlsFlsConfig().isNowAllowedInQueries()) {
            return () -> System.currentTimeMillis();
        }
        return () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
    }
}

