/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.client;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.RefCounted;

public class RefCountedGuard<T extends RefCounted>
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(RefCountedGuard.class);
    private final List<T> releasable = new LinkedList<T>();

    public void add(T refCounted) {
        Objects.requireNonNull(refCounted, "Ref counted is required");
        this.releasable.add(refCounted);
        log.debug("Ref counted {} added.", refCounted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Iterator<T> iterator = this.releasable.iterator();
        while (iterator.hasNext()) {
            RefCounted refCounted = (RefCounted)iterator.next();
            try {
                refCounted.decRef();
            }
            catch (Exception e) {
                log.error("Cannot release resource related to ref counted '{}'", (Object)refCounted, (Object)e);
            }
            finally {
                iterator.remove();
            }
        }
        log.debug("Release resources related to ref counted");
    }

    @Override
    public void close() {
        this.release();
        log.debug("Resources realised in close method");
    }
}

