/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.BCPGOutputStream;
import com.floragunn.searchguard.lpg.ContainedPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TrustPacket
extends ContainedPacket {
    byte[] levelAndTrustAmount;

    public TrustPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    public TrustPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(12, newPacketFormat);
        int ch;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            bOut.write(ch);
        }
        this.levelAndTrustAmount = bOut.toByteArray();
    }

    public TrustPacket(int trustCode) {
        super(12);
        this.levelAndTrustAmount = new byte[1];
        this.levelAndTrustAmount[0] = (byte)trustCode;
    }

    public byte[] getLevelAndTrustAmount() {
        return this.levelAndTrustAmount;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.hasNewPacketFormat(), 12, this.levelAndTrustAmount);
    }
}

