/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.ArmoredInputStream;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.HashAlgorithmTags;
import com.floragunn.searchguard.lpg.Integers;
import com.floragunn.searchguard.lpg.MPInteger;
import com.floragunn.searchguard.lpg.Strings;
import com.floragunn.searchguard.lpg.asn1.ASN1Integer;
import com.floragunn.searchguard.lpg.asn1.ASN1Sequence;
import com.floragunn.searchguard.lpg.open.PGPException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static Map<String, Integer> nameToHashId = new HashMap<String, Integer>(){
        {
            this.put("sha1", Integers.valueOf(2));
            this.put("sha224", Integers.valueOf(11));
            this.put("sha256", Integers.valueOf(8));
            this.put("sha384", Integers.valueOf(9));
            this.put("sha512", Integers.valueOf(10));
            this.put("sha3-224", Integers.valueOf(312));
            this.put("sha3-256", Integers.valueOf(12));
            this.put("sha3-384", Integers.valueOf(314));
            this.put("sha3-512", Integers.valueOf(14));
            this.put("ripemd160", Integers.valueOf(3));
            this.put("rmd160", Integers.valueOf(3));
            this.put("md2", Integers.valueOf(5));
            this.put("md4", Integers.valueOf(301));
            this.put("tiger", Integers.valueOf(6));
            this.put("haval", Integers.valueOf(7));
            this.put("sm3", Integers.valueOf(326));
            this.put("md5", Integers.valueOf(1));
        }
    };
    private static final int READ_AHEAD = 60;

    public static String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 12: 
            case 313: {
                return "SHA3-256";
            }
            case 314: {
                return "SHA3-384";
            }
            case 14: 
            case 315: {
                return "SHA3-512";
            }
            case 312: {
                return "SHA3-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    public static int getDigestIDForName(String name) {
        if (nameToHashId.containsKey(name = Strings.toLowerCase(name))) {
            return nameToHashId.get(name);
        }
        throw new IllegalArgumentException("unable to map " + name + " to a hash id");
    }

    public static String getSignatureName(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg;
    }

    public static String getSymmetricCipherName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: 
            case 8: 
            case 9: {
                return "AES";
            }
            case 11: 
            case 12: 
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + algorithm);
    }

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String provider) {
        defProvider = provider;
    }

    static MPInteger[] dsaSigToMpi(byte[] encoding) throws PGPException {
        ASN1Integer i2;
        ASN1Integer i1;
        try {
            ASN1Sequence s = ASN1Sequence.getInstance(encoding);
            i1 = ASN1Integer.getInstance(s.getObjectAt(0));
            i2 = ASN1Integer.getInstance(s.getObjectAt(1));
        }
        catch (RuntimeException e) {
            throw new PGPException("exception decoding signature", e);
        }
        return new MPInteger[]{new MPInteger(i1.getValue()), new MPInteger(i2.getValue())};
    }

    public static boolean isKeyRing(byte[] blob) throws IOException {
        BCPGInputStream bIn = new BCPGInputStream(new ByteArrayInputStream(blob));
        int tag = bIn.nextPacketTag();
        return tag == 6 || tag == 14 || tag == 5 || tag == 7;
    }

    public static boolean isKeyBox(byte[] data) throws IOException {
        if (data.length < 12) {
            return false;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        for (int i = 0; i != 8; ++i) {
            ((InputStream)bIn).read();
        }
        return ((InputStream)bIn).read() == 75 && ((InputStream)bIn).read() == 66 && ((InputStream)bIn).read() == 88 && ((InputStream)bIn).read() == 102;
    }

    public static byte[] makeRandomKey(int algorithm, SecureRandom random) throws PGPException {
        int keySize;
        switch (algorithm) {
            case 2: 
            case 8: 
            case 12: {
                keySize = 192;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                keySize = 128;
                break;
            }
            case 6: {
                keySize = 64;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                keySize = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        random.nextBytes(keyBytes);
        return keyBytes;
    }

    private static boolean isPossiblyBase64(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 43 || ch == 47 || ch == 13 || ch == 10;
    }

    public static InputStream getDecoderStream(InputStream in) throws IOException {
        int count;
        if (!in.markSupported()) {
            in = new BufferedInputStreamExt(in);
        }
        in.mark(60);
        int ch = in.read();
        if ((ch & 0x80) != 0) {
            in.reset();
            return in;
        }
        if (!PGPUtil.isPossiblyBase64(ch)) {
            in.reset();
            return new ArmoredInputStream(in);
        }
        byte[] buf = new byte[60];
        int index = 1;
        buf[0] = (byte)ch;
        for (count = 1; count != 60 && (ch = in.read()) >= 0; ++count) {
            if (!PGPUtil.isPossiblyBase64(ch)) {
                in.reset();
                return new ArmoredInputStream(in);
            }
            if (ch == 10 || ch == 13) continue;
            buf[index++] = (byte)ch;
        }
        in.reset();
        if (count < 4) {
            return new ArmoredInputStream(in);
        }
        byte[] firstBlock = new byte[8];
        System.arraycopy(buf, 0, firstBlock, 0, firstBlock.length);
        try {
            byte[] decoded = Base64.getDecoder().decode(firstBlock);
            if ((decoded[0] & 0x80) != 0) {
                return new ArmoredInputStream(in, false);
            }
            return new ArmoredInputStream(in);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream input) {
            super(input);
        }

        @Override
        public synchronized int available() throws IOException {
            int result = super.available();
            if (result < 0) {
                result = Integer.MAX_VALUE;
            }
            return result;
        }
    }
}

